/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.nio.charset.Charset;

public class UTF8String
implements CharSequence {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private final byte[] str;
    private String s;
    private int hash;

    public UTF8String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public UTF8String(byte[] byArray, int n, int n2) {
        this.str = new byte[n2];
        System.arraycopy(byArray, n, this.str, 0, n2);
    }

    public UTF8String(char[] cArray, int n, int n2) {
        this.str = new String(cArray, n, n2).getBytes(UTF8);
    }

    public UTF8String(String string) {
        this.s = string;
        this.str = string.getBytes(UTF8);
    }

    public static UTF8String format(String string, Object ... objectArray) {
        return new UTF8String(String.format(string, objectArray));
    }

    public int get(int n) {
        return this.str[n];
    }

    public byte[] getBytes() {
        return this.str;
    }

    public int byteSize() {
        return this.str.length;
    }

    @Override
    public String toString() {
        if (this.s == null) {
            this.s = new String(this.str, UTF8);
        }
        return this.s;
    }

    public int hashCode() {
        int n = this.hash;
        int n2 = this.byteSize();
        if (n == 0 && n2 > 0) {
            int n3 = 0;
            byte[] byArray = this.str;
            for (int i = 0; i < n2; ++i) {
                n = 31 * n + byArray[n3++];
            }
            this.hash = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            UTF8String uTF8String = (UTF8String)UTF8String.class.cast(object);
            int n = this.byteSize();
            if (n == uTF8String.byteSize()) {
                byte[] byArray = this.str;
                byte[] byArray2 = uTF8String.str;
                int n2 = 0;
                int n3 = 0;
                while (n-- != 0) {
                    if (byArray[n2++] == byArray2[n3++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }
}

