/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.xerial.util.ArrayDeque;

public class LineReader
implements Iterable<String> {
    private int lineCount = 0;
    private BufferedReader reader;
    private boolean hasFinishedReading = false;

    public LineReader(File file) throws FileNotFoundException {
        this.reader = LineReader.wrap(new FileReader(file));
    }

    public LineReader(File file, int n) throws FileNotFoundException {
        this.reader = LineReader.wrap(new FileReader(file), n);
    }

    public LineReader(Reader reader) {
        this.reader = LineReader.wrap(reader);
    }

    public LineReader(Reader reader, int n) {
        this.reader = LineReader.wrap(reader, n);
    }

    private static BufferedReader wrap(Reader reader) {
        if (BufferedReader.class.isAssignableFrom(reader.getClass())) {
            return (BufferedReader)BufferedReader.class.cast(reader);
        }
        return new BufferedReader(reader);
    }

    private static BufferedReader wrap(Reader reader, int n) {
        return new BufferedReader(reader, n);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public String readLine() throws IOException {
        String string = this.reader.readLine();
        if (string != null) {
            ++this.lineCount;
        } else {
            this.close();
        }
        return string;
    }

    public void close() throws IOException {
        if (!this.hasFinishedReading) {
            this.hasFinishedReading = true;
            this.reader.close();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            ArrayDeque<String> queue = new ArrayDeque();

            @Override
            public boolean hasNext() {
                if (!this.queue.isEmpty()) {
                    return true;
                }
                try {
                    String string = LineReader.this.readLine();
                    if (string != null) {
                        this.queue.addLast(string);
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    return null;
                }
                return this.queue.pollFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

