/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FileType
extends Enum<FileType> {
    public static final /* enum */ FileType UNKNOWN = new FileType("");
    public static final /* enum */ FileType JPEG = new FileType("jpeg,jpg");
    public static final /* enum */ FileType PNG = new FileType("png");
    public static final /* enum */ FileType GIF = new FileType("gif");
    public static final /* enum */ FileType BMP = new FileType("bmp");
    public static final /* enum */ FileType TIFF = new FileType("tiff");
    public static final /* enum */ FileType XML = new FileType("xml");
    public static final /* enum */ FileType JSON = new FileType("json");
    public static final /* enum */ FileType SILK = new FileType("silk");
    public static final /* enum */ FileType TAB = new FileType("tab");
    public static final /* enum */ FileType CSV = new FileType("csv");
    public static final /* enum */ FileType FASTA = new FileType("fasta,fa,fs");
    public static final /* enum */ FileType TEX = new FileType("tex");
    public static final /* enum */ FileType TEXT = new FileType("txt");
    public static final /* enum */ FileType HTML = new FileType("html,htm");
    public static final /* enum */ FileType PDF = new FileType("pdf");
    public static final /* enum */ FileType PS = new FileType("ps");
    public static final /* enum */ FileType WORD = new FileType("doc,docx");
    public static final /* enum */ FileType EXCEL = new FileType("xls,xlsx");
    public static final /* enum */ FileType POWER_POINT = new FileType("ppt,pptx");
    public static final /* enum */ FileType ZIP = new FileType("zip");
    public static final /* enum */ FileType GZIP = new FileType("gz,gzip");
    public static final /* enum */ FileType TAR = new FileType("tar");
    public static final /* enum */ FileType TAR_GZ = new FileType("tar.gz");
    public static final /* enum */ FileType BZIP2 = new FileType("bz2");
    private static HashMap<String, FileType> fileTypeTable;
    private ArrayList<String> fileExtList;
    private static final /* synthetic */ FileType[] $VALUES;

    public static FileType[] values() {
        return (FileType[])$VALUES.clone();
    }

    public static FileType valueOf(String string) {
        return Enum.valueOf(FileType.class, string);
    }

    private FileType() {
        this.fileExtList = new ArrayList(0);
    }

    private FileType(String string2) {
        String[] stringArray = string2.split(",\\s*");
        assert (stringArray != null);
        this.fileExtList = new ArrayList(stringArray.length);
        for (String string3 : stringArray) {
            this.fileExtList.add(string3);
        }
    }

    public List<String> getFileExtList() {
        return this.fileExtList;
    }

    public static FileType getFileTypeFromFileExt(String string) {
        FileType fileType = fileTypeTable.get(string.toLowerCase());
        if (fileType == null) {
            return UNKNOWN;
        }
        return fileType;
    }

    public static FileType getFileType(String string) {
        if (string.endsWith("tar.gz")) {
            return FileType.getFileTypeFromFileExt("tar.gz");
        }
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            return UNKNOWN;
        }
        return FileType.getFileTypeFromFileExt(string.substring(n + 1));
    }

    public static String removeFileExt(String string) {
        if (string.endsWith("tar.gz")) {
            return string.substring(0, string.length() - "tar.gz".length() - 1);
        }
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String replaceFileExt(String string, String string2) {
        String string3 = FileType.removeFileExt(string);
        return string3 + "." + string2;
    }

    static {
        $VALUES = new FileType[]{UNKNOWN, JPEG, PNG, GIF, BMP, TIFF, XML, JSON, SILK, TAB, CSV, FASTA, TEX, TEXT, HTML, PDF, PS, WORD, EXCEL, POWER_POINT, ZIP, GZIP, TAR, TAR_GZ, BZIP2};
        fileTypeTable = new HashMap();
        for (FileType fileType : FileType.values()) {
            for (String string : fileType.getFileExtList()) {
                fileTypeTable.put(string, fileType);
            }
        }
    }
}

