/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xerial.util.FileUtil;
import org.xerial.util.ResourceFilter;
import org.xerial.util.io.VirtualFile;
import org.xerial.util.log.Logger;

public class FileResource {
    private static Logger _logger = Logger.getLogger(FileResource.class);

    public static List<VirtualFile> listResources(String string) {
        return FileResource.listResources(string, new ResourceFilter(){

            @Override
            public boolean accept(String string) {
                return true;
            }
        });
    }

    public static List<VirtualFile> listResources(String string, ClassLoader classLoader) {
        return FileResource.listResources(classLoader, string, new ResourceFilter(){

            @Override
            public boolean accept(String string) {
                return true;
            }
        });
    }

    public static List<VirtualFile> listResources(ResourceFilter resourceFilter) {
        return FileResource.listResources(Thread.currentThread().getContextClassLoader(), resourceFilter);
    }

    public static List<VirtualFile> listResources(ClassLoader classLoader, ResourceFilter resourceFilter) {
        ArrayList<URLClassLoader> arrayList = FileResource.getAllAncestorOrSelfClassLoaders(classLoader);
        ArrayList<VirtualFile> arrayList2 = new ArrayList<VirtualFile>();
        for (URLClassLoader uRLClassLoader : arrayList) {
            for (URL uRL : uRLClassLoader.getURLs()) {
                arrayList2.addAll(FileResource.listResources(uRL, "", resourceFilter));
            }
        }
        return arrayList2;
    }

    public static List<VirtualFile> listResources(URL uRL, String string, ResourceFilter resourceFilter) {
        _logger.trace("listResource: url=" + uRL);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        if (uRL == null) {
            return arrayList;
        }
        String string2 = uRL.getProtocol();
        if (string2.equals("file")) {
            String string3 = uRL.toString();
            FileResource.collectFileResources(string3, arrayList, string, resourceFilter);
        } else if (string2.equals("jar")) {
            String string4 = uRL.getPath();
            int n = string4.indexOf("!");
            if (n < 0) {
                throw new IllegalArgumentException("invalid resource URL: " + uRL);
            }
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 2);
            try {
                String string7 = "jar:" + string5;
                string5 = string5.replaceAll("%20", " ").replace("file:", "");
                string6 = string6.replaceAll("%20", " ");
                JarFile jarFile = new JarFile(string5);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string8 = string7 + "!/" + jarEntry.getName();
                    URL uRL2 = new URL(string8);
                    String string9 = FileResource.extractLogicalName(string, jarEntry.getName());
                    if (string9 == null || !resourceFilter.accept(string9)) continue;
                    arrayList.add(new FileInJarArchive(uRL2, string9, jarEntry.isDirectory()));
                }
            }
            catch (MalformedURLException malformedURLException) {
                _logger.error(malformedURLException);
            }
            catch (IOException iOException) {
                _logger.error(iOException);
            }
        } else {
            throw new UnsupportedOperationException("resources other than file or jar are not supported: " + uRL);
        }
        return arrayList;
    }

    public static List<VirtualFile> listResources(String string, ResourceFilter resourceFilter) {
        return FileResource.listResources(Thread.currentThread().getContextClassLoader(), string, resourceFilter);
    }

    public static List<VirtualFile> listResources(ClassLoader classLoader, String string, ResourceFilter resourceFilter) {
        String string2 = FileResource.packagePath(string);
        ArrayList<URL> arrayList = FileResource.getURLListFromAllAncestorOrSelfClassLoaders(classLoader, string2);
        ArrayList<VirtualFile> arrayList2 = new ArrayList<VirtualFile>();
        for (URL uRL : arrayList) {
            arrayList2.addAll(FileResource.listResources(uRL, string2, resourceFilter));
        }
        return arrayList2;
    }

    private static void collectFileResources(String string, ArrayList<VirtualFile> arrayList, String string2, ResourceFilter resourceFilter) {
        if (string.endsWith(".svn")) {
            return;
        }
        String string3 = FileResource.extractLogicalName(string2, string);
        if (string3 == null) {
            throw new IllegalArgumentException("packagePath=" + string2 + ", resourceURL=" + string);
        }
        try {
            File file = new File(new URL(string).toURI());
            if (resourceFilter.accept(file.getPath())) {
                arrayList.add(new SystemFile(file, string3));
            }
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    String string4 = string + (string.endsWith("/") ? "" : "/") + file2.getName();
                    FileResource.collectFileResources(string4, arrayList, string2, resourceFilter);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error(malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            _logger.error(uRISyntaxException);
        }
    }

    private static String extractLogicalName(String string, String string2) {
        int n;
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((n = string2.indexOf(string)) < 0) {
            return null;
        }
        String string3 = string2.substring(n + string.length());
        return string3;
    }

    public static ArrayList<URLClassLoader> getAllAncestorOrSelfClassLoaders(ClassLoader classLoader) {
        ArrayList<URLClassLoader> arrayList = new ArrayList<URLClassLoader>();
        for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            if (!URLClassLoader.class.isInstance(classLoader2)) continue;
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
            arrayList.add(uRLClassLoader);
        }
        return arrayList;
    }

    private static ArrayList<URL> getURLListFromAllAncestorOrSelfClassLoaders(ClassLoader classLoader, String string) {
        String string2 = !string.endsWith("/") ? string + "/" : string;
        ArrayList<URLClassLoader> arrayList = FileResource.getAllAncestorOrSelfClassLoaders(classLoader);
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        try {
            for (URLClassLoader uRLClassLoader : arrayList) {
                Enumeration<URL> enumeration = uRLClassLoader.findResources(string2);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    arrayList2.add(uRL);
                }
            }
        }
        catch (IOException iOException) {
            _logger.error(iOException);
        }
        return arrayList2;
    }

    private static String packagePath(Class<?> clazz) {
        return FileResource.packagePath(clazz.getPackage());
    }

    private static String packagePath(Package package_) {
        return FileResource.packagePath(package_.getName());
    }

    private static String packagePath(String string) {
        String string2 = string.replaceAll("\\.", "/");
        return string2.endsWith("/") ? string2 : string2 + "/";
    }

    public static BufferedReader open(Class<?> clazz, String string) throws IOException {
        URL uRL = FileResource.find(clazz, string);
        if (uRL != null) {
            return new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        return null;
    }

    public static BufferedReader open(Class<?> clazz, String string, String string2) throws IOException {
        URL uRL = FileResource.find(clazz, string);
        if (uRL != null) {
            return new BufferedReader(new InputStreamReader(uRL.openStream(), string2));
        }
        return null;
    }

    public static BufferedReader open(Package package_, String string) throws IOException {
        URL uRL = FileResource.find(package_, string);
        if (uRL != null) {
            return new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        return null;
    }

    public static BufferedInputStream openByteStream(Class<?> clazz, String string) throws IOException {
        URL uRL = FileResource.find(clazz, string);
        if (uRL != null) {
            return new BufferedInputStream(uRL.openStream());
        }
        return null;
    }

    public static BufferedInputStream openByteStream(Package package_, String string) throws IOException {
        URL uRL = FileResource.find(package_, string);
        if (uRL != null) {
            return new BufferedInputStream(uRL.openStream());
        }
        return null;
    }

    public static URL find(Class<?> clazz, String string) {
        return FileResource.find(clazz.getPackage(), string);
    }

    public static URL find(Package package_, String string) {
        return FileResource.find(package_.getName(), string);
    }

    public static URL find(String string, String string2) {
        String string3 = FileResource.packagePath(string);
        String string4 = string3 + string2;
        if (!string4.startsWith("/")) {
            string4 = "/" + string4;
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace("search resource: " + string4);
        }
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            URL uRL = classLoader.getResource(string4);
            if (uRL == null) continue;
            return uRL;
        }
        return FileResource.class.getResource(string4);
    }

    public static URL findFromJAR(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalArgumentException("not found the jar: " + uRL);
            }
            File file = new File(uRL.toString());
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                jarEntry.isDirectory();
            }
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error(malformedURLException);
            throw new IllegalArgumentException("cannot find the jar: " + string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static URL find(String string) {
        return FileResource.find("", string);
    }

    public static <T> List<Class<T>> findClasses(Package package_, Class<T> clazz, ClassLoader classLoader) {
        ArrayList<Class<T>> arrayList = new ArrayList<Class<T>>();
        String string = package_.getName();
        List<VirtualFile> list = FileResource.listResources(classLoader, string, new ResourceFilter(){

            @Override
            public boolean accept(String string) {
                return string.endsWith(".class");
            }
        });
        for (VirtualFile virtualFile : list) {
            String string2 = virtualFile.getLogicalPath();
            int n = string2.lastIndexOf(".");
            if (n <= 0) continue;
            String string3 = string + "." + string2.substring(0, n).replaceAll("/", ".");
            try {
                Class<?> clazz2 = Class.forName(string3, false, classLoader);
                if (Modifier.isAbstract(clazz2.getModifiers()) || !clazz.isAssignableFrom(clazz2)) continue;
                arrayList.add(clazz2);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> File copyToTemp(Class<T> clazz, String string, File file) throws IOException {
        BufferedInputStream bufferedInputStream = FileResource.openByteStream(clazz, string);
        try {
            if (bufferedInputStream == null) {
                throw new FileNotFoundException(string);
            }
            File file2 = FileUtil.createTempFile(file, "tmp-", new File(string).getName());
            FileUtil.copy(bufferedInputStream, file2);
            File file3 = file2;
            return file3;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String loadIntoString(Class<T> clazz, String string) throws IOException {
        BufferedInputStream bufferedInputStream = FileResource.openByteStream(clazz, string);
        if (bufferedInputStream == null) {
            throw new FileNotFoundException(String.format("reference class:%s, path:%s", clazz.getName(), string));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[4028];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            String string2 = byteArrayOutputStream.toString();
            return string2;
        }
        finally {
            bufferedInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String loadIntoString(Package package_, String string) throws IOException {
        BufferedInputStream bufferedInputStream = FileResource.openByteStream(package_, string);
        if (bufferedInputStream == null) {
            throw new FileNotFoundException(String.format("reference package:%s, path:%s", package_.getName(), string));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[4028];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            String string2 = byteArrayOutputStream.toString();
            return string2;
        }
        finally {
            bufferedInputStream.close();
        }
    }

    public static class FileInJarArchive
    implements VirtualFile {
        private URL resourceURL;
        private String logicalPath;
        boolean isDirectory;

        public FileInJarArchive(URL uRL, String string, boolean bl) {
            this.resourceURL = uRL;
            this.logicalPath = string;
            this.isDirectory = bl;
            if (this.resourceURL == null) {
                throw new IllegalArgumentException("resource URL cannot be null: " + string);
            }
        }

        @Override
        public String getLogicalPath() {
            return this.logicalPath;
        }

        @Override
        public URL getURL() {
            return this.resourceURL;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public String toString() {
            return this.getURL().toString();
        }
    }

    public static class SystemFile
    implements VirtualFile {
        private File file;
        private String logicalPath;

        public SystemFile(File file, String string) {
            this.file = file;
            this.logicalPath = string;
        }

        @Override
        public String getLogicalPath() {
            return this.logicalPath;
        }

        @Override
        public URL getURL() {
            try {
                return this.file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException(malformedURLException);
            }
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public String toString() {
            return this.getURL().toString();
        }
    }
}

