/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.List;

public class BitVector {
    private static final int BIT_LENGTH = 32;
    private ArrayList<Integer> bitVector = new ArrayList();
    private int size = 0;

    public BitVector() {
    }

    public BitVector(int n) {
        this.extend(n - 1);
    }

    public void on(int n) {
        this.set(n, true);
    }

    public void off(int n) {
        this.set(n, false);
    }

    public void set(int n, boolean bl) {
        this.extend(n);
        int n2 = BitVector.pos(n);
        int n3 = 1 << BitVector.offset(n);
        int n4 = this.bitVector.get(n2);
        this.bitVector.set(n2, bl ? (n4 = n4 | n3) : (n4 = n4 & ~n3));
    }

    public boolean get(int n) {
        int n2 = BitVector.pos(n);
        if (n2 >= this.bitVector.size()) {
            return false;
        }
        int n3 = this.bitVector.get(n2);
        int n4 = 1 << BitVector.offset(n);
        return (n3 &= n4) != 0;
    }

    private static int pos(int n) {
        return n / 32;
    }

    private static int offset(int n) {
        return n % 32;
    }

    private void extend(int n) {
        int n2;
        if (this.size <= n) {
            this.size = n + 1;
        }
        if ((n2 = BitVector.pos(n)) < this.bitVector.size()) {
            return;
        }
        while (this.bitVector.size() <= n2) {
            this.bitVector.add(0);
        }
    }

    public boolean equals(Object object) {
        if (!BitVector.class.isInstance(object)) {
            return false;
        }
        BitVector bitVector = (BitVector)BitVector.class.cast(object);
        if (this.size() != bitVector.size()) {
            return false;
        }
        int n = this.byteLength();
        for (int i = 0; i < n; ++i) {
            if (this.bitVector.get(i).equals(bitVector.bitVector.get(i))) continue;
            return false;
        }
        return true;
    }

    private int byteLength() {
        int n = this.size() - 1;
        if (n < 0) {
            n = 0;
        }
        return BitVector.pos(n) + (BitVector.offset(n) == 0 ? 0 : 1);
    }

    public int hashCode() {
        int n = 3;
        int n2 = this.byteLength();
        for (int i = 0; i < n2; ++i) {
            n += n * 137 + this.bitVector.get(i);
        }
        return n % 1987;
    }

    private BitVector(List<Integer> list, int n) {
        this.size = n;
        for (int n2 : list) {
            this.bitVector.add(n2);
        }
    }

    public static BitVector newInstance(BitVector bitVector) {
        return new BitVector(bitVector.bitVector, bitVector.size);
    }

    public static BitVector newInstanceWithAnAdditionalBit(BitVector bitVector, int n) {
        BitVector bitVector2 = new BitVector(bitVector.bitVector, bitVector.size);
        bitVector2.on(n);
        return bitVector2;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.bitVector.clear();
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.get(i) ? "1" : "0");
        }
        return stringBuilder.toString();
    }
}

