/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.io.IOException;
import java.io.Reader;
import org.xerial.json.JSONEvent;
import org.xerial.json.JSONPullParser;
import org.xerial.util.ArrayDeque;
import org.xerial.util.tree.TreeEvent;
import org.xerial.util.tree.TreeEventHandler;
import org.xerial.util.tree.TreeParser;

public class JSONTreeParser
implements TreeParser {
    private final JSONPullParser jsonPullParser;
    private JSONEvent lastEvent = null;
    private ArrayDeque<TreeEvent> pendingEventQueue = new ArrayDeque();

    public JSONTreeParser(String string) {
        this.jsonPullParser = new JSONPullParser(string);
    }

    public JSONTreeParser(Reader reader) throws IOException {
        this.jsonPullParser = new JSONPullParser(reader);
    }

    @Override
    public void parse(TreeEventHandler treeEventHandler) throws Exception {
        treeEventHandler.init();
        this.parseJSON(treeEventHandler);
        treeEventHandler.finish();
    }

    private void flushPendingEvent(TreeEventHandler treeEventHandler) throws Exception {
        while (!this.pendingEventQueue.isEmpty()) {
            TreeEvent treeEvent = this.pendingEventQueue.removeFirst();
            switch (treeEvent.event) {
                case VISIT: {
                    treeEventHandler.visitNode(treeEvent.nodeName, treeEvent.nodeValue);
                    break;
                }
                case LEAVE: {
                    treeEventHandler.leaveNode(treeEvent.nodeName);
                    break;
                }
                case TEXT: {
                    treeEventHandler.text(treeEvent.nodeName, treeEvent.nodeValue);
                }
            }
        }
    }

    private void parseJSON(TreeEventHandler treeEventHandler) throws Exception {
        while (this.lastEvent != JSONEvent.EndJSON) {
            this.lastEvent = this.jsonPullParser.next();
            switch (this.lastEvent) {
                case StartObject: {
                    this.flushPendingEvent(treeEventHandler);
                    String string2 = this.jsonPullParser.getKeyName();
                    this.pendingEventQueue.addLast(TreeEvent.newVisitEvent(string2, null));
                    break;
                }
                case EndObject: {
                    this.flushPendingEvent(treeEventHandler);
                    String string2 = this.jsonPullParser.getKeyName();
                    treeEventHandler.leaveNode(string2);
                    break;
                }
                case String: 
                case Integer: 
                case Double: 
                case True: 
                case False: 
                case Null: {
                    String string;
                    String string2 = this.jsonPullParser.getKeyName();
                    String string3 = string = this.lastEvent != JSONEvent.Null ? this.jsonPullParser.getText() : null;
                    if (string2 != null && string2.equals("value") && !this.pendingEventQueue.isEmpty()) {
                        TreeEvent treeEvent = this.pendingEventQueue.peekLast();
                        if (treeEvent.event == TreeEvent.EventType.VISIT) {
                            this.pendingEventQueue.removeLast();
                            this.pendingEventQueue.addLast(TreeEvent.newVisitEvent(treeEvent.nodeName, string));
                            break;
                        }
                    }
                    this.flushPendingEvent(treeEventHandler);
                    treeEventHandler.visitNode(string2, string);
                    treeEventHandler.leaveNode(string2);
                    break;
                }
            }
        }
    }
}

