/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xerial.json.JSONArray;
import org.xerial.json.JSONElement;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONException;
import org.xerial.json.JSONNumber;
import org.xerial.json.JSONPullParser;
import org.xerial.json.JSONString;
import org.xerial.json.JSONValue;
import org.xerial.json.JSONValueBase;
import org.xerial.json.JSONValueType;

public class JSONObject
extends JSONValueBase {
    JSONObjectContent content = new JSONObjectContent();

    public JSONObject() {
    }

    public JSONObject(String string) throws JSONException {
        new JSONPullParser(string).populateJSONObject(this);
    }

    public static JSONObject parse(String string) throws JSONException {
        return new JSONObject(string);
    }

    public JSONObject(List<JSONElement> list) {
        for (JSONElement jSONElement : list) {
            this.put(jSONElement.getKey(), jSONElement.getValue());
        }
    }

    public void put(String string, JSONValue jSONValue) {
        this.content.put(string, jSONValue);
    }

    public void put(String string, Object object) throws JSONException {
        this.content.put(string, this.translateAsJSONValue(object));
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : this.content.entrySet()) {
            String string = "\"" + (String)entry.getKey() + "\"";
            String string2 = entry.getValue() == null ? "null" : ((JSONValue)entry.getValue()).toJSONString();
            arrayList.add(string + ":" + string2);
        }
        stringBuilder.append(JSONObject.join(arrayList, ","));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int elementSize() {
        return this.content.size();
    }

    public JSONValue get(String string) {
        return (JSONValue)this.content.get(string);
    }

    public Set<String> keys() {
        return this.content.keySet();
    }

    public int getInt(String string) throws JSONException {
        JSONValue jSONValue = this.get(string);
        if (jSONValue == null) {
            throw new JSONException(JSONErrorCode.KeyIsNotFound, string);
        }
        JSONNumber jSONNumber = jSONValue.getJSONNumber();
        if (jSONNumber == null) {
            throw new JSONException(JSONErrorCode.NotAJSONNumber, jSONValue.toString());
        }
        return jSONNumber.getIntValue();
    }

    public String getString(String string) throws JSONException {
        JSONValue jSONValue = this.get(string);
        if (jSONValue == null) {
            throw new JSONException(JSONErrorCode.KeyIsNotFound, string);
        }
        JSONString jSONString = jSONValue.getJSONString();
        if (jSONString == null) {
            throw new JSONException(JSONErrorCode.NotAJSONString, jSONValue.toString());
        }
        return jSONString.getValue();
    }

    @Override
    public JSONObject getJSONObject() {
        return this;
    }

    public JSONArray getJSONArray(String string) {
        JSONValue jSONValue = this.get(string);
        if (jSONValue == null) {
            return null;
        }
        JSONArray jSONArray = jSONValue.getJSONArray();
        if (jSONArray == null) {
            return null;
        }
        return jSONArray;
    }

    public boolean hasKey(String string) {
        return this.content.containsKey(string);
    }

    public Map<String, JSONValue> getKeyValueMap() {
        return this.content;
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        JSONValue jSONValue = this.get(string);
        if (jSONValue == null) {
            throw new JSONException(JSONErrorCode.KeyIsNotFound, string);
        }
        JSONObject jSONObject = jSONValue.getJSONObject();
        if (jSONObject == null) {
            throw new JSONException(JSONErrorCode.NotAJSONObject, jSONValue.toString());
        }
        return jSONObject;
    }

    @Override
    public JSONValueType getValueType() {
        return JSONValueType.Object;
    }

    public void remove(String string) {
        this.content.remove(string);
    }

    class JSONObjectContent
    extends LinkedHashMap<String, JSONValue> {
        JSONObjectContent() {
        }
    }
}

