/*
 * Decompiled with CFR 0.152.
 */
package xerial.core.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.ServerSocket;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;

public final class IOUtil$ {
    public static final IOUtil$ MODULE$;

    static {
        new IOUtil$();
    }

    public <U> U readFile(String fileName, Function1<Source, U> f) {
        BufferedSource source = Source$.MODULE$.fromFile(fileName, Codec$.MODULE$.fallbackSystemCodec());
        return (U)f.apply((Object)source);
    }

    public int randomPort() {
        ServerSocket s = new ServerSocket(0);
        try {
            return s.getLocalPort();
        }
        finally {
            s.close();
        }
    }

    public <U, In extends Closeable> U withResource(In in, Function1<In, U> f) {
        try {
            return (U)f.apply(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public <U> U readFully(InputStream in, Function1<byte[], U> f) {
        byte[] byteArray = (byte[])this.withResource((Closeable)new ByteArrayOutputStream(), (Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final byte[] apply(ByteArrayOutputStream b) {
                byte[] buf = new byte[8192];
                IOUtil$.MODULE$.withResource(this.in$1, new Serializable(this, b, buf){
                    public static final long serialVersionUID = 0L;
                    private final ByteArrayOutputStream b$1;
                    private final byte[] buf$1;

                    public final void apply(InputStream src) {
                        int readBytes = 0;
                        while ((readBytes = src.read(this.buf$1)) != -1) {
                            this.b$1.write(this.buf$1, 0, readBytes);
                        }
                    }
                    {
                        this.b$1 = b$1;
                        this.buf$1 = buf$1;
                    }
                });
                return b.toByteArray();
            }
            {
                this.in$1 = in$1;
            }
        });
        return (U)f.apply((Object)byteArray);
    }

    public void ensureParentPath(File f) {
        File parent = f.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public File createTempDir(File dir, String prefix) {
        return this.loop$1(dir, prefix);
    }

    private final File newDirName$1(File dir$1, String prefix$1) {
        return new File(dir$1, new StringBuilder().append((Object)prefix$1).append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
    }

    private final File loop$1(File dir$1, String prefix$1) {
        File d;
        while ((d = this.newDirName$1(dir$1, prefix$1)).exists() || !d.mkdirs()) {
        }
        return d;
    }

    private IOUtil$() {
        MODULE$ = this;
    }
}

