/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.StarExpressionAstNode;
import org.apache.pinot.spi.utils.EqualityUtils;

public class FunctionCallAstNode
extends BaseAstNode {
    private final String _name;
    private String _expression;
    private boolean _isInSelectList;

    public FunctionCallAstNode(String name, String expression) {
        this._name = name;
        this._expression = expression;
        this._isInSelectList = true;
    }

    public boolean equals(Object obj) {
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)obj)) {
            return false;
        }
        if (EqualityUtils.isSameReference((Object)this, (Object)obj)) {
            return true;
        }
        FunctionCallAstNode functionCallAstNode = (FunctionCallAstNode)obj;
        return this._name.equals(functionCallAstNode.getName()) && this._expression.equals(functionCallAstNode.getExpression());
    }

    public int hashCode() {
        int hashCode = EqualityUtils.hashCodeOf((Object)this._name);
        hashCode = EqualityUtils.hashCodeOf((int)hashCode, (Object)this._expression);
        hashCode = EqualityUtils.hashCodeOf((int)hashCode, (boolean)this._isInSelectList);
        return hashCode;
    }

    public void setIsInSelectList(boolean value) {
        this._isInSelectList = value;
    }

    public String getName() {
        return this._name;
    }

    public String getExpression() {
        return this._expression;
    }

    AggregationInfo buildAggregationInfo() {
        ArrayList<String> functionArgs = new ArrayList<String>();
        if (this._name.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
            functionArgs.add("*");
        } else {
            List<? extends AstNode> children = this.getChildren();
            if (children == null || children.isEmpty()) {
                throw new Pql2CompilationException("Aggregation function expects non-null argument");
            }
            if (this._name.equalsIgnoreCase(AggregationFunctionType.DISTINCT.getName()) && children.size() == 1 && children.get(0) instanceof StarExpressionAstNode) {
                throw new Pql2CompilationException("Syntax error: Pinot currently does not support DISTINCT with *. Please specify each column name as argument to DISTINCT function");
            }
            if (this._name.equalsIgnoreCase(AggregationFunctionType.DISTINCT.getName())) {
                TreeSet<String> expressionsSet = new TreeSet<String>();
                for (AstNode astNode : children) {
                    String expression = TransformExpressionTree.getStandardExpression(astNode);
                    if (!expressionsSet.add(expression)) continue;
                    functionArgs.add(expression);
                }
            } else {
                for (AstNode astNode : children) {
                    functionArgs.add(TransformExpressionTree.getStandardExpression(astNode));
                }
            }
        }
        AggregationInfo aggregationInfo = new AggregationInfo();
        aggregationInfo.setAggregationType(this._name);
        aggregationInfo.setExpressions(functionArgs);
        aggregationInfo.setIsInSelectList(this._isInSelectList);
        aggregationInfo.putToAggregationParams("column", String.join((CharSequence)":", functionArgs));
        return aggregationInfo;
    }

    @Override
    public String toString() {
        return "FunctionCallAstNode{_name='" + this._name + '\'' + '}';
    }
}

