/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;

public class ComparisonPredicateAstNode
extends PredicateAstNode {
    private final String _operand;
    private LiteralAstNode _literal;

    public ComparisonPredicateAstNode(String operand) {
        this._operand = operand;
    }

    public LiteralAstNode getLiteral() {
        return this._literal;
    }

    public String getOperand() {
        return this._operand;
    }

    public String getValue() {
        return this._literal.getValueAsString();
    }

    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("Comparison predicate has more than one column/function");
            }
            this._identifier = ((IdentifierAstNode)childNode).getName();
        } else if (childNode instanceof FunctionCallAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("Comparison predicate has more than one column/function");
            }
            this._identifier = TransformExpressionTree.getStandardExpression(childNode);
        } else if (childNode instanceof LiteralAstNode) {
            if (this._literal != null) {
                throw new Pql2CompilationException("Comparison between two constants is not supported");
            }
            this._literal = (LiteralAstNode)childNode;
        }
        super.addChild(childNode);
    }

    private String createRangeStringForComparison() {
        String comparison = null;
        String value = this._literal.getValueAsString();
        boolean identifierIsOnLeft = true;
        if (this.getChildren().get(0) instanceof LiteralAstNode) {
            identifierIsOnLeft = false;
        }
        if ("<".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "(*\t\t" + value + ")" : "(" + value + "\t\t*)";
        } else if ("<=".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "(*\t\t" + value + "]" : "[" + value + "\t\t*)";
        } else if (">".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "(" + value + "\t\t*)" : "(*\t\t" + value + "*)";
        } else if (">=".equals(this._operand)) {
            comparison = identifierIsOnLeft ? "[" + value + "\t\t*)" : "(*\t\t" + value + "*)";
        }
        return comparison;
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("Comparison predicate has no identifier");
        }
        if ("=".equals(this._operand)) {
            if (this._identifier != null && this._literal != null) {
                return new FilterQueryTree(this._identifier, Collections.singletonList(this._literal.getValueAsString()), FilterOperator.EQUALITY, null);
            }
            throw new Pql2CompilationException("Comparison is not between a column and a constant");
        }
        if ("<>".equals(this._operand) || "!=".equals(this._operand)) {
            if (this._identifier != null && this._literal != null) {
                return new FilterQueryTree(this._identifier, Collections.singletonList(this._literal.getValueAsString()), FilterOperator.NOT, null);
            }
            throw new Pql2CompilationException("Comparison is not between a column and a constant");
        }
        String comparison = this.createRangeStringForComparison();
        if (comparison == null) {
            throw new Pql2CompilationException("The comparison operator is not valid/is not supported for HAVING query");
        }
        if (this._identifier != null) {
            return new FilterQueryTree(this._identifier, Collections.singletonList(comparison), FilterOperator.RANGE, null);
        }
        throw new Pql2CompilationException("One column is needed for comparison.");
    }

    @Override
    public Expression buildFilterExpression() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("Comparison predicate has no identifier");
        }
        if ("=".equals(this._operand)) {
            if (this._identifier != null && this._literal != null) {
                Expression expr = RequestUtils.getFunctionExpression(FilterKind.EQUALS.name());
                expr.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
                expr.getFunctionCall().addToOperands(RequestUtils.createLiteralExpression(this._literal));
                return expr;
            }
            throw new Pql2CompilationException("Comparison is not between a column and a constant");
        }
        if ("<>".equals(this._operand) || "!=".equals(this._operand)) {
            if (this._identifier != null && this._literal != null) {
                Expression expr = RequestUtils.getFunctionExpression(FilterKind.NOT_EQUALS.name());
                expr.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
                expr.getFunctionCall().addToOperands(RequestUtils.createLiteralExpression(this._literal));
                return expr;
            }
            throw new Pql2CompilationException("Comparison is not between a column and a constant");
        }
        if (this._identifier != null) {
            boolean identifierIsOnLeft = true;
            if (this.getChildren().get(0) instanceof LiteralAstNode) {
                identifierIsOnLeft = false;
            }
            Expression expr = null;
            if ("<".equals(this._operand)) {
                expr = identifierIsOnLeft ? RequestUtils.getFunctionExpression(FilterKind.LESS_THAN.name()) : RequestUtils.getFunctionExpression(FilterKind.GREATER_THAN.name());
            } else if ("<=".equals(this._operand)) {
                expr = identifierIsOnLeft ? RequestUtils.getFunctionExpression(FilterKind.LESS_THAN_OR_EQUAL.name()) : RequestUtils.getFunctionExpression(FilterKind.GREATER_THAN_OR_EQUAL.name());
            } else if (">".equals(this._operand)) {
                expr = identifierIsOnLeft ? RequestUtils.getFunctionExpression(FilterKind.GREATER_THAN.name()) : RequestUtils.getFunctionExpression(FilterKind.LESS_THAN.name());
            } else if (">=".equals(this._operand)) {
                expr = identifierIsOnLeft ? RequestUtils.getFunctionExpression(FilterKind.GREATER_THAN_OR_EQUAL.name()) : RequestUtils.getFunctionExpression(FilterKind.LESS_THAN_OR_EQUAL.name());
            }
            if (expr == null) {
                throw new Pql2CompilationException("The comparison operator is not valid/is not supported for HAVING query");
            }
            expr.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
            expr.getFunctionCall().addToOperands(RequestUtils.createLiteralExpression(this._literal));
            return expr;
        }
        throw new Pql2CompilationException("One column is needed for comparison.");
    }
}

