/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;

public class BetweenPredicateAstNode
extends PredicateAstNode {
    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("BETWEEN predicate has more than one column/function");
            }
            this._identifier = ((IdentifierAstNode)childNode).getName();
        } else if (childNode instanceof FunctionCallAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("BETWEEN predicate has more than one column/function");
            }
            this._identifier = TransformExpressionTree.getStandardExpression(childNode);
        } else {
            super.addChild(childNode);
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("Between predicate has no identifier");
        }
        if (this.getChildren().size() == 2) {
            try {
                LiteralAstNode left = (LiteralAstNode)this.getChildren().get(0);
                LiteralAstNode right = (LiteralAstNode)this.getChildren().get(1);
                return new FilterQueryTree(this._identifier, Collections.singletonList("[" + left.getValueAsString() + "\t\t" + right.getValueAsString() + "]"), FilterOperator.RANGE, null);
            }
            catch (ClassCastException e) {
                throw new Pql2CompilationException("BETWEEN clause was expecting two literal AST nodes, got " + this.getChildren().get(0) + " and " + this.getChildren().get(1));
            }
        }
        throw new Pql2CompilationException("BETWEEN clause does not have two children nodes");
    }

    @Override
    public Expression buildFilterExpression() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("Between predicate has no identifier");
        }
        if (this.getChildren().size() == 2) {
            try {
                LiteralAstNode left = (LiteralAstNode)this.getChildren().get(0);
                LiteralAstNode right = (LiteralAstNode)this.getChildren().get(1);
                Expression betweenExpr = RequestUtils.getFunctionExpression(FilterKind.BETWEEN.name());
                Function rangeFuncCall = betweenExpr.getFunctionCall();
                rangeFuncCall.addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
                rangeFuncCall.addToOperands(RequestUtils.createLiteralExpression(left));
                rangeFuncCall.addToOperands(RequestUtils.createLiteralExpression(right));
                return betweenExpr;
            }
            catch (ClassCastException e) {
                throw new Pql2CompilationException("BETWEEN clause was expecting two literal AST nodes, got " + this.getChildren());
            }
        }
        throw new Pql2CompilationException("BETWEEN clause does not have two children nodes");
    }
}

