/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.parsers.AbstractCompiler;
import org.apache.pinot.parsers.utils.BrokerRequestComparisonUtils;
import org.apache.pinot.pql.parsers.PQL2Lexer;
import org.apache.pinot.pql.parsers.PQL2Parser;
import org.apache.pinot.pql.parsers.PinotQuery2BrokerRequestConverter;
import org.apache.pinot.pql.parsers.Pql2AstListener;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Pql2Compiler
implements AbstractCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pql2Compiler.class);
    public static boolean ENABLE_PINOT_QUERY = Boolean.valueOf(System.getProperty("pinot.query.converter.enabled", "false"));
    public static boolean VALIDATE_CONVERTER = Boolean.valueOf(System.getProperty("pinot.query.converter.validate", "false"));
    public static boolean FAIL_ON_CONVERSION_ERROR = Boolean.valueOf(System.getProperty("pinot.query.converter.fail_on_error", "false"));
    private static final ErrorListener ERROR_LISTENER = new ErrorListener();

    @Override
    public BrokerRequest compileToBrokerRequest(String expression) throws Pql2CompilationException {
        try {
            BrokerRequest brokerRequest;
            block8: {
                ANTLRInputStream charStream = new ANTLRInputStream(expression);
                PQL2Lexer lexer = new PQL2Lexer((CharStream)charStream);
                lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
                UnbufferedTokenStream tokenStream = new UnbufferedTokenStream((TokenSource)lexer);
                PQL2Parser parser = new PQL2Parser((TokenStream)tokenStream);
                parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
                PQL2Parser.RootContext parseTree = parser.root();
                ParseTreeWalker walker = new ParseTreeWalker();
                Pql2AstListener listener = new Pql2AstListener(expression);
                walker.walk((ParseTreeListener)listener, (ParseTree)parseTree);
                AstNode rootNode = listener.getRootNode();
                brokerRequest = new BrokerRequest();
                rootNode.updateBrokerRequest(brokerRequest);
                if (ENABLE_PINOT_QUERY) {
                    try {
                        PinotQuery2BrokerRequestConverter converter;
                        BrokerRequest tempBrokerRequest;
                        boolean result;
                        PinotQuery pinotQuery = new PinotQuery();
                        rootNode.updatePinotQuery(pinotQuery);
                        if (VALIDATE_CONVERTER && !(result = BrokerRequestComparisonUtils.validate(brokerRequest, tempBrokerRequest = (converter = new PinotQuery2BrokerRequestConverter()).convert(pinotQuery)))) {
                            LOGGER.error("Pinot query to broker request conversion failed. PQL:{}", (Object)expression);
                            if (FAIL_ON_CONVERSION_ERROR) {
                                throw new Pql2CompilationException("Pinot query to broker request conversion failed. PQL:" + expression);
                            }
                        }
                        brokerRequest.setPinotQuery(pinotQuery);
                    }
                    catch (Exception e) {
                        LOGGER.error("Non fatal: Failed to populate pinot query and broker request. PQL:{}", (Object)expression, (Object)e);
                        if (!FAIL_ON_CONVERSION_ERROR) break block8;
                        throw e;
                    }
                }
            }
            return brokerRequest;
        }
        catch (Pql2CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Pql2CompilationException(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public AstNode parseToAstNode(String expression) {
        ANTLRInputStream charStream = new ANTLRInputStream(expression);
        PQL2Lexer lexer = new PQL2Lexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        UnbufferedTokenStream tokenStream = new UnbufferedTokenStream((TokenSource)lexer);
        PQL2Parser parser = new PQL2Parser((TokenStream)tokenStream);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        Pql2AstListener listener = new Pql2AstListener(expression);
        new ParseTreeWalker().walk((ParseTreeListener)listener, (ParseTree)parser.expression());
        return listener.getRootNode();
    }

    public TransformExpressionTree compileToExpressionTree(String expression) {
        return new TransformExpressionTree(this.parseToAstNode(expression));
    }

    public static AstNode buildAst(String expression) {
        ANTLRInputStream charStream = new ANTLRInputStream(expression);
        PQL2Lexer lexer = new PQL2Lexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        UnbufferedTokenStream tokenStream = new UnbufferedTokenStream((TokenSource)lexer);
        PQL2Parser parser = new PQL2Parser((TokenStream)tokenStream);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        PQL2Parser.RootContext parseTree = parser.root();
        ParseTreeWalker walker = new ParseTreeWalker();
        Pql2AstListener listener = new Pql2AstListener(expression);
        walker.walk((ParseTreeListener)listener, (ParseTree)parseTree);
        AstNode rootNode = listener.getRootNode();
        return rootNode;
    }

    private static class ErrorListener
    extends BaseErrorListener {
        private ErrorListener() {
        }

        public void syntaxError(@Nonnull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @Nonnull String msg, @Nullable RecognitionException e) {
            throw new Pql2CompilationException(msg, offendingSymbol, line, charPositionInLine, e);
        }
    }
}

