/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.parsers.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;

public class ParserUtils {
    private static final Map<FilterKind, FilterOperator> FILTER_OPERATOR_MAP = new HashMap<FilterKind, FilterOperator>();

    private ParserUtils() {
    }

    public static FilterOperator getFilterType(Expression expression) {
        String operator = expression.getFunctionCall().getOperator();
        return ParserUtils.filterKindToOperator(FilterKind.valueOf(operator));
    }

    public static FilterKind getFilterKind(Expression expression) {
        String operator = expression.getFunctionCall().getOperator();
        return FilterKind.valueOf(operator);
    }

    public static FilterOperator filterKindToOperator(FilterKind filterKind) {
        return FILTER_OPERATOR_MAP.get((Object)filterKind);
    }

    public static String getFilterColumn(Expression expression) {
        Function functionCall = expression.getFunctionCall();
        Expression operand = functionCall.getOperands().get(0);
        return ParserUtils.standardizeExpression(operand, false);
    }

    public static List<String> getFilterValues(Expression filterExpression) {
        Function function = filterExpression.getFunctionCall();
        FilterKind filterKind = FilterKind.valueOf(function.getOperator());
        return ParserUtils.getFilterValues(filterKind, function.getOperands());
    }

    public static List<String> getFilterValues(FilterKind filterKind, List<Expression> operands) {
        String rangeExpression;
        ArrayList<String> valueList = new ArrayList<String>();
        if (!filterKind.isRange()) {
            for (int i = 1; i < operands.size(); ++i) {
                valueList.add(ParserUtils.standardizeExpression(operands.get(i), true));
            }
            return valueList;
        }
        boolean treatLiteralAsIdentifier = true;
        if (FilterKind.LESS_THAN == filterKind) {
            String value = ParserUtils.standardizeExpression(operands.get(1), treatLiteralAsIdentifier);
            rangeExpression = "(*\t\t" + value + ")";
        } else if (FilterKind.LESS_THAN_OR_EQUAL == filterKind) {
            String value = ParserUtils.standardizeExpression(operands.get(1), treatLiteralAsIdentifier);
            rangeExpression = "(*\t\t" + value + "]";
        } else if (FilterKind.GREATER_THAN == filterKind) {
            String value = ParserUtils.standardizeExpression(operands.get(1), treatLiteralAsIdentifier);
            rangeExpression = "(" + value + "\t\t*)";
        } else if (FilterKind.GREATER_THAN_OR_EQUAL == filterKind) {
            String value = ParserUtils.standardizeExpression(operands.get(1), treatLiteralAsIdentifier);
            rangeExpression = "[" + value + "\t\t*)";
        } else if (FilterKind.BETWEEN == filterKind) {
            String left = ParserUtils.standardizeExpression(operands.get(1), treatLiteralAsIdentifier);
            String right = ParserUtils.standardizeExpression(operands.get(2), treatLiteralAsIdentifier);
            rangeExpression = "[" + left + "\t\t" + right + "]";
        } else {
            throw new UnsupportedOperationException("Unknown Filter Kind:" + (Object)((Object)filterKind));
        }
        valueList.add(rangeExpression);
        return valueList;
    }

    public static String standardizeExpression(Expression expression, boolean treatLiteralAsIdentifier) {
        return ParserUtils.standardizeExpression(expression, treatLiteralAsIdentifier, false);
    }

    public static String standardizeExpression(Expression expression, boolean treatLiteralAsIdentifier, boolean forceSingleQuoteOnNonStringLiteral) {
        switch (expression.getType()) {
            case LITERAL: {
                Literal literal = expression.getLiteral();
                if (forceSingleQuoteOnNonStringLiteral && !literal.isSetStringValue()) {
                    return "'" + literal.getFieldValue() + "'";
                }
                if (treatLiteralAsIdentifier || !literal.isSetStringValue()) {
                    return literal.getFieldValue().toString();
                }
                return "'" + literal.getFieldValue() + "'";
            }
            case IDENTIFIER: {
                return expression.getIdentifier().getName();
            }
            case FUNCTION: {
                Function functionCall = expression.getFunctionCall();
                return ParserUtils.standardizeFunction(functionCall);
            }
        }
        throw new UnsupportedOperationException("Unknown Expression type: " + (Object)((Object)expression.getType()));
    }

    public static String standardizeFunction(Function functionCall) {
        StringBuilder sb = new StringBuilder();
        sb.append(functionCall.getOperator().toLowerCase());
        sb.append("(");
        String delim = "";
        for (Expression operand : functionCall.getOperands()) {
            sb.append(delim);
            sb.append(ParserUtils.standardizeExpression(operand, false, true));
            delim = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        FILTER_OPERATOR_MAP.put(FilterKind.AND, FilterOperator.AND);
        FILTER_OPERATOR_MAP.put(FilterKind.OR, FilterOperator.OR);
        FILTER_OPERATOR_MAP.put(FilterKind.EQUALS, FilterOperator.EQUALITY);
        FILTER_OPERATOR_MAP.put(FilterKind.NOT_EQUALS, FilterOperator.NOT);
        FILTER_OPERATOR_MAP.put(FilterKind.GREATER_THAN, FilterOperator.RANGE);
        FILTER_OPERATOR_MAP.put(FilterKind.LESS_THAN, FilterOperator.RANGE);
        FILTER_OPERATOR_MAP.put(FilterKind.GREATER_THAN_OR_EQUAL, FilterOperator.RANGE);
        FILTER_OPERATOR_MAP.put(FilterKind.LESS_THAN_OR_EQUAL, FilterOperator.RANGE);
        FILTER_OPERATOR_MAP.put(FilterKind.BETWEEN, FilterOperator.RANGE);
        FILTER_OPERATOR_MAP.put(FilterKind.IN, FilterOperator.IN);
        FILTER_OPERATOR_MAP.put(FilterKind.NOT_IN, FilterOperator.NOT_IN);
        FILTER_OPERATOR_MAP.put(FilterKind.REGEXP_LIKE, FilterOperator.REGEXP_LIKE);
        FILTER_OPERATOR_MAP.put(FilterKind.IS_NULL, FilterOperator.IS_NULL);
        FILTER_OPERATOR_MAP.put(FilterKind.IS_NOT_NULL, FilterOperator.IS_NOT_NULL);
        FILTER_OPERATOR_MAP.put(FilterKind.TEXT_MATCH, FilterOperator.TEXT_MATCH);
    }
}

