/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.List;
import org.apache.pinot.common.request.FilterOperator;

public class FilterQueryTree {
    private final String column;
    private final List<String> value;
    private final FilterOperator operator;
    private final List<FilterQueryTree> children;

    public FilterQueryTree(String column, List<String> value, FilterOperator operator, List<FilterQueryTree> children) {
        this.column = column;
        this.value = value;
        this.operator = operator;
        this.children = children;
    }

    public String getColumn() {
        return this.column;
    }

    public List<String> getValue() {
        return this.value;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public List<FilterQueryTree> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.recursiveToStringIntoBuffer(0, stringBuffer);
        return stringBuffer.toString();
    }

    private void recursiveToStringIntoBuffer(int indent, StringBuffer stringBuffer) {
        for (int i = 0; i < indent; ++i) {
            stringBuffer.append(' ');
        }
        if (this.operator == FilterOperator.OR || this.operator == FilterOperator.AND) {
            stringBuffer.append((Object)this.operator);
            for (FilterQueryTree child : this.children) {
                stringBuffer.append('\n');
                child.recursiveToStringIntoBuffer(indent + 1, stringBuffer);
            }
        } else {
            stringBuffer.append(this.column).append(' ').append((Object)this.operator).append(' ').append(this.value);
        }
    }
}

