/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;

public class PinotHelixPropertyStoreZnRecordProvider {
    private final ZkHelixPropertyStore<ZNRecord> propertyStore;
    private final String pathPrefix;

    private PinotHelixPropertyStoreZnRecordProvider() {
        this.pathPrefix = null;
        this.propertyStore = null;
    }

    private PinotHelixPropertyStoreZnRecordProvider(ZkHelixPropertyStore<ZNRecord> propertyStore, String relativePathName) {
        this.propertyStore = propertyStore;
        this.pathPrefix = relativePathName;
    }

    public static PinotHelixPropertyStoreZnRecordProvider forSchema(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return new PinotHelixPropertyStoreZnRecordProvider(propertyStore, "/SCHEMAS");
    }

    public static PinotHelixPropertyStoreZnRecordProvider forTable(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return new PinotHelixPropertyStoreZnRecordProvider(propertyStore, "/CONFIGS/TABLES");
    }

    public static PinotHelixPropertyStoreZnRecordProvider forSegments(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return new PinotHelixPropertyStoreZnRecordProvider(propertyStore, "/SEGMENTS");
    }

    public ZNRecord get(String name) {
        return (ZNRecord)this.propertyStore.get(this.pathPrefix + "/" + name, null, AccessOption.PERSISTENT);
    }

    public void set(String name, ZNRecord record) {
        this.propertyStore.set(this.pathPrefix + "/" + name, (Object)record, AccessOption.PERSISTENT);
    }

    public boolean exist(String path) {
        return this.propertyStore.exists(this.pathPrefix + "/" + path, AccessOption.PERSISTENT);
    }

    public String getRelativePath() {
        return this.pathPrefix;
    }
}

