/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.utils.fetcher.HttpSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.HttpsSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.PinotFSSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.SegmentFetcher;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.crypt.PinotCrypterFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFetcherFactory {
    static final String SEGMENT_FETCHER_CLASS_KEY_SUFFIX = ".class";
    private static final String PROTOCOLS_KEY = "protocols";
    private static final String ENCODED_SUFFIX = ".enc";
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentFetcherFactory.class);
    private static final Map<String, SegmentFetcher> SEGMENT_FETCHER_MAP = new HashMap<String, SegmentFetcher>();
    private static final SegmentFetcher DEFAULT_HTTP_SEGMENT_FETCHER = new HttpSegmentFetcher();
    private static final SegmentFetcher DEFAULT_PINOT_FS_SEGMENT_FETCHER = new PinotFSSegmentFetcher();

    private SegmentFetcherFactory() {
    }

    public static void init(PinotConfiguration config) throws Exception {
        List protocols = config.getProperty(PROTOCOLS_KEY, Arrays.asList(new String[0]));
        for (String protocol : protocols) {
            SegmentFetcher segmentFetcher;
            String segmentFetcherClassName = config.getProperty(protocol + SEGMENT_FETCHER_CLASS_KEY_SUFFIX);
            if (segmentFetcherClassName == null) {
                LOGGER.info("Segment fetcher class is not configured for protocol: {}, using default", (Object)protocol);
                switch (protocol) {
                    case "http": {
                        segmentFetcher = new HttpSegmentFetcher();
                        break;
                    }
                    case "https": {
                        segmentFetcher = new HttpsSegmentFetcher();
                        break;
                    }
                    default: {
                        segmentFetcher = new PinotFSSegmentFetcher();
                        break;
                    }
                }
            } else {
                LOGGER.info("Creating segment fetcher for protocol: {} with class: {}", (Object)protocol, (Object)segmentFetcherClassName);
                segmentFetcher = (SegmentFetcher)Class.forName(segmentFetcherClassName).newInstance();
            }
            segmentFetcher.init(config.subset(protocol));
            SEGMENT_FETCHER_MAP.put(protocol, segmentFetcher);
        }
    }

    public static SegmentFetcher getSegmentFetcher(String protocol) {
        SegmentFetcher segmentFetcher = SEGMENT_FETCHER_MAP.get(protocol);
        if (segmentFetcher != null) {
            return segmentFetcher;
        }
        LOGGER.info("Segment fetcher is not configured for protocol: {}, using default", (Object)protocol);
        switch (protocol) {
            case "http": 
            case "https": {
                return DEFAULT_HTTP_SEGMENT_FETCHER;
            }
        }
        return DEFAULT_PINOT_FS_SEGMENT_FETCHER;
    }

    public static void fetchSegmentToLocal(URI uri, File dest) throws Exception {
        SegmentFetcherFactory.getSegmentFetcher(uri.getScheme()).fetchSegmentToLocal(uri, dest);
    }

    public static void fetchSegmentToLocal(String uri, File dest) throws Exception {
        SegmentFetcherFactory.fetchSegmentToLocal(new URI(uri), dest);
    }

    public static void fetchAndDecryptSegmentToLocal(String uri, File dest, String crypterName) throws Exception {
        if (crypterName == null) {
            SegmentFetcherFactory.fetchSegmentToLocal(uri, dest);
        } else {
            File tempDownloadedFile = new File(dest.getPath() + ENCODED_SUFFIX);
            SegmentFetcherFactory.fetchSegmentToLocal(uri, tempDownloadedFile);
            PinotCrypter crypter = PinotCrypterFactory.create((String)crypterName);
            crypter.decrypt(tempDownloadedFile, dest);
        }
    }

    static {
        PinotConfiguration emptyConfig = new PinotConfiguration();
        DEFAULT_HTTP_SEGMENT_FETCHER.init(emptyConfig);
        DEFAULT_PINOT_FS_SEGMENT_FETCHER.init(emptyConfig);
    }
}

