/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TagOverrideConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.tenant.TenantRole;

public class TagNameUtils {
    public static final String DEFAULT_TENANT_NAME = "DefaultTenant";
    private static final String BROKER_TAG_SUFFIX = "_" + TenantRole.BROKER;
    private static final String OFFLINE_SERVER_TAG_SUFFIX = "_" + TableType.OFFLINE;
    private static final String REALTIME_SERVER_TAG_SUFFIX = "_" + TableType.REALTIME;

    private TagNameUtils() {
    }

    public static boolean isBrokerTag(String tagName) {
        return tagName.endsWith(BROKER_TAG_SUFFIX);
    }

    public static boolean isServerTag(String tagName) {
        return TagNameUtils.isOfflineServerTag(tagName) || TagNameUtils.isRealtimeServerTag(tagName);
    }

    public static boolean isOfflineServerTag(String tagName) {
        return tagName.endsWith(OFFLINE_SERVER_TAG_SUFFIX);
    }

    public static boolean isRealtimeServerTag(String tagName) {
        return tagName.endsWith(REALTIME_SERVER_TAG_SUFFIX);
    }

    public static String getTenantFromTag(String tagName) {
        return tagName.substring(0, tagName.lastIndexOf(95));
    }

    public static String getBrokerTagForTenant(@Nullable String tenantName) {
        return TagNameUtils.getTagForTenant(tenantName, BROKER_TAG_SUFFIX);
    }

    public static String getOfflineTagForTenant(@Nullable String tenantName) {
        return TagNameUtils.getTagForTenant(tenantName, OFFLINE_SERVER_TAG_SUFFIX);
    }

    public static String getRealtimeTagForTenant(@Nullable String tenantName) {
        return TagNameUtils.getTagForTenant(tenantName, REALTIME_SERVER_TAG_SUFFIX);
    }

    private static String getTagForTenant(@Nullable String tenantName, String tagSuffix) {
        if (tenantName == null) {
            return DEFAULT_TENANT_NAME + tagSuffix;
        }
        return tenantName + tagSuffix;
    }

    public static String extractBrokerTag(TenantConfig tenantConfig) {
        return TagNameUtils.getBrokerTagForTenant(tenantConfig.getBroker());
    }

    public static String extractOfflineServerTag(TenantConfig tenantConfig) {
        return TagNameUtils.getOfflineTagForTenant(tenantConfig.getServer());
    }

    public static String extractConsumingServerTag(TenantConfig tenantConfig) {
        TagOverrideConfig tagOverrideConfig = tenantConfig.getTagOverrideConfig();
        if (tagOverrideConfig == null || tagOverrideConfig.getRealtimeConsuming() == null) {
            return TagNameUtils.getRealtimeTagForTenant(tenantConfig.getServer());
        }
        return tagOverrideConfig.getRealtimeConsuming();
    }

    public static String extractCompletedServerTag(TenantConfig tenantConfig) {
        TagOverrideConfig tagOverrideConfig = tenantConfig.getTagOverrideConfig();
        if (tagOverrideConfig == null || tagOverrideConfig.getRealtimeCompleted() == null) {
            return TagNameUtils.getRealtimeTagForTenant(tenantConfig.getServer());
        }
        return tagOverrideConfig.getRealtimeCompleted();
    }

    public static boolean isRelocateCompletedSegments(TenantConfig tenantConfig) {
        if (tenantConfig.getTagOverrideConfig() == null) {
            return false;
        }
        return !TagNameUtils.extractConsumingServerTag(tenantConfig).equals(TagNameUtils.extractCompletedServerTag(tenantConfig));
    }
}

