/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.spi.config.instance.Instance;

public class InstanceUtils {
    public static final String POOL_KEY = "pool";
    public static final String GRPC_PORT_KEY = "grpcPort";

    private InstanceUtils() {
    }

    public static String getHelixInstanceId(Instance instance) {
        String prefix;
        switch (instance.getType()) {
            case CONTROLLER: {
                prefix = "Controller_";
                break;
            }
            case BROKER: {
                prefix = "Broker_";
                break;
            }
            case SERVER: {
                prefix = "Server_";
                break;
            }
            case MINION: {
                prefix = "Minion_";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return prefix + instance.getHost() + "_" + instance.getPort();
    }

    public static InstanceConfig toHelixInstanceConfig(Instance instance) {
        Map pools;
        InstanceConfig instanceConfig = InstanceConfig.toInstanceConfig((String)InstanceUtils.getHelixInstanceId(instance));
        List tags = instance.getTags();
        if (tags != null) {
            for (String tag : tags) {
                instanceConfig.addTag(tag);
            }
        }
        if ((pools = instance.getPools()) != null && !pools.isEmpty()) {
            TreeMap mapValue = new TreeMap();
            for (Map.Entry entry : pools.entrySet()) {
                mapValue.put(entry.getKey(), ((Integer)entry.getValue()).toString());
            }
            instanceConfig.getRecord().setMapField(POOL_KEY, mapValue);
        }
        instanceConfig.getRecord().setSimpleField(GRPC_PORT_KEY, Integer.toString(instance.getGrpcPort()));
        return instanceConfig;
    }
}

