/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringJoiner;

public class URIUtils {
    private URIUtils() {
    }

    public static URI getUri(String basePath, String ... parts) {
        String path = URIUtils.getPath(basePath, parts);
        try {
            URI uri = new URI(path);
            if (uri.getScheme() != null) {
                return uri;
            }
            return new URI("file:" + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal URI path: " + path, e);
        }
    }

    public static String getPath(String basePath, String ... parts) {
        StringJoiner stringJoiner = new StringJoiner(File.separator);
        stringJoiner.add(basePath);
        for (String part : parts) {
            stringJoiner.add(part);
        }
        return stringJoiner.toString();
    }

    public static String constructDownloadUrl(String baseUrl, String rawTableName, String segmentName) {
        return URIUtils.getPath(baseUrl, "segments", rawTableName, URIUtils.encode(segmentName));
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

