/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TarGzCompressionUtils {
    public static final String TAR_GZ_FILE_EXTENSION = ".tar.gz";
    private static final char ENTRY_NAME_SEPARATOR = '/';

    private TarGzCompressionUtils() {
    }

    public static void createTarGzFile(File inputFile, File outputFile) throws IOException {
        Preconditions.checkArgument((boolean)outputFile.getName().endsWith(TAR_GZ_FILE_EXTENSION), (String)"Output file: %s does not have '.tar.gz' file extension", (Object)outputFile);
        try (OutputStream fileOut = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
             BufferedOutputStream bufferedOut = new BufferedOutputStream(fileOut);
             GzipCompressorOutputStream gzipOut = new GzipCompressorOutputStream((OutputStream)bufferedOut);
             TarArchiveOutputStream tarGzOut = new TarArchiveOutputStream((OutputStream)gzipOut);){
            tarGzOut.setLongFileMode(2);
            TarGzCompressionUtils.addFileToTarGz((ArchiveOutputStream)tarGzOut, inputFile, "");
        }
    }

    private static void addFileToTarGz(ArchiveOutputStream tarGzOut, File file, String baseEntryName) throws IOException {
        String entryName = baseEntryName + file.getName();
        TarArchiveEntry entry = new TarArchiveEntry(file, entryName);
        tarGzOut.putArchiveEntry((ArchiveEntry)entry);
        if (file.isFile()) {
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)tarGzOut);
            }
            tarGzOut.closeArchiveEntry();
        } else {
            tarGzOut.closeArchiveEntry();
            File[] children = file.listFiles();
            assert (children != null);
            String baseEntryNameForChildren = entryName + '/';
            for (File child : children) {
                TarGzCompressionUtils.addFileToTarGz(tarGzOut, child, baseEntryNameForChildren);
            }
        }
    }

    public static List<File> untar(File inputFile, File outputDir) throws IOException {
        String outputDirCanonicalPath = outputDir.getCanonicalPath();
        ArrayList<File> untarredFiles = new ArrayList<File>();
        try (InputStream fileIn = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);
             BufferedInputStream bufferedIn = new BufferedInputStream(fileIn);
             GzipCompressorInputStream gzipIn = new GzipCompressorInputStream((InputStream)bufferedIn);
             TarArchiveInputStream tarGzIn = new TarArchiveInputStream((InputStream)gzipIn);){
            ArchiveEntry entry;
            while ((entry = tarGzIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                String[] parts = StringUtils.split((String)entryName, (char)'/');
                File outputFile = outputDir;
                for (String part : parts) {
                    outputFile = new File(outputFile, part);
                }
                if (entry.isDirectory()) {
                    if (!outputFile.getCanonicalPath().startsWith(outputDirCanonicalPath)) {
                        throw new IOException(String.format("Trying to create directory: %s outside of the output directory: %s", outputFile, outputDir));
                    }
                    if (!outputFile.isDirectory() && !outputFile.mkdirs()) {
                        throw new IOException(String.format("Failed to create directory: %s", outputFile));
                    }
                } else {
                    File parentFile = outputFile.getParentFile();
                    if (!parentFile.getCanonicalPath().startsWith(outputDirCanonicalPath)) {
                        throw new IOException(String.format("Trying to create directory: %s outside of the output directory: %s", parentFile, outputDir));
                    }
                    if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                        throw new IOException(String.format("Failed to create directory: %s", parentFile));
                    }
                    try (OutputStream out = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
                        IOUtils.copy((InputStream)tarGzIn, (OutputStream)out);
                    }
                }
                untarredFiles.add(outputFile);
            }
        }
        return untarredFiles;
    }

    /*
     * Exception decompiling
     */
    public static void untarOneFile(File inputFile, String fileName, File outputFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 47[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

