/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.helix.ZNRecord;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUtils.class);
    private static final HttpClient HTTP_CLIENT = new HttpClient();

    private SchemaUtils() {
    }

    public static Schema fromZNRecord(@Nonnull ZNRecord record) throws IOException {
        String schemaJSON = record.getSimpleField("schemaJSON");
        return Schema.fromString((String)schemaJSON);
    }

    public static ZNRecord toZNRecord(@Nonnull Schema schema) {
        ZNRecord record = new ZNRecord(schema.getSchemaName());
        record.setSimpleField("schemaJSON", schema.toSingleLineJsonString());
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Schema getSchema(@Nonnull String host, int port, @Nonnull String schemaName) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)schemaName);
        try {
            URL url = new URL("http", host, port, "/schemas/" + schemaName);
            GetMethod httpGet = new GetMethod(url.toString());
            try {
                int responseCode = HTTP_CLIENT.executeMethod((HttpMethod)httpGet);
                String response = httpGet.getResponseBodyAsString();
                if (responseCode >= 400) {
                    if (responseCode == 404) {
                        LOGGER.info("Cannot find schema: {} from host: {}, port: {}", new Object[]{schemaName, host, port});
                    } else {
                        LOGGER.warn("Got error response code: {}, response: {}", (Object)responseCode, (Object)response);
                    }
                    Schema schema = null;
                    return schema;
                }
                Schema schema = Schema.fromString((String)response);
                return schema;
            }
            finally {
                httpGet.releaseConnection();
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting the schema: {} from host: {}, port: {}", new Object[]{schemaName, host, port, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean postSchema(@Nonnull String host, int port, @Nonnull Schema schema) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)schema);
        try {
            URL url = new URL("http", host, port, "/schemas");
            PostMethod httpPost = new PostMethod(url.toString());
            try {
                Part[] parts = new Part[]{new StringPart(schema.getSchemaName(), schema.toSingleLineJsonString())};
                MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts, new HttpMethodParams());
                httpPost.setRequestEntity((RequestEntity)requestEntity);
                int responseCode = HTTP_CLIENT.executeMethod((HttpMethod)httpPost);
                if (responseCode >= 400) {
                    String response = httpPost.getResponseBodyAsString();
                    LOGGER.warn("Got error response code: {}, response: {}", (Object)responseCode, (Object)response);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                httpPost.releaseConnection();
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while posting the schema: {} to host: {}, port: {}", new Object[]{schema.getSchemaName(), host, port, e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteSchema(@Nonnull String host, int port, @Nonnull String schemaName) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)schemaName);
        try {
            URL url = new URL("http", host, port, "/schemas/" + schemaName);
            DeleteMethod httpDelete = new DeleteMethod(url.toString());
            try {
                int responseCode = HTTP_CLIENT.executeMethod((HttpMethod)httpDelete);
                if (responseCode >= 400) {
                    String response = httpDelete.getResponseBodyAsString();
                    LOGGER.warn("Got error response code: {}, response: {}", (Object)responseCode, (Object)response);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                httpDelete.releaseConnection();
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting the schema: {} from host: {}, port: {}", new Object[]{schemaName, host, port, e});
            return false;
        }
    }

    public static boolean equalsIgnoreVersion(@Nonnull Schema schema1, @Nonnull Schema schema2) {
        Preconditions.checkNotNull((Object)schema1);
        Preconditions.checkNotNull((Object)schema2);
        return schema1.getSchemaName().equals(schema2.getSchemaName()) && schema1.getFieldSpecMap().equals(schema2.getFieldSpecMap());
    }

    public static void main(String[] args) {
        Schema schema = new Schema.SchemaBuilder().setSchemaName("testSchema").addSingleValueDimension("dimension", FieldSpec.DataType.DOUBLE).addMetric("metric", FieldSpec.DataType.INT).addTime(new TimeGranularitySpec(FieldSpec.DataType.INT, TimeUnit.DAYS, "time"), null).build();
        System.out.println(SchemaUtils.postSchema("localhost", 8100, schema));
        Schema fetchedSchema = SchemaUtils.getSchema("localhost", 8100, "testSchema");
        Preconditions.checkNotNull((Object)fetchedSchema);
        System.out.println(fetchedSchema);
        System.out.println(SchemaUtils.equalsIgnoreVersion(schema, fetchedSchema));
        System.out.println(SchemaUtils.deleteSchema("localhost", 8100, "testSchema"));
    }
}

