/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import org.apache.commons.lang3.ArrayUtils;

public class PrimitiveArrayUtils {
    public static Object toPrimitive(Object array) {
        if (array instanceof int[] || array instanceof long[] || array instanceof short[] || array instanceof byte[] || array instanceof char[] || array instanceof float[] || array instanceof double[] || array instanceof boolean[]) {
            return array;
        }
        if (array instanceof Integer[]) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])array));
        }
        if (array instanceof Long[]) {
            return ArrayUtils.toPrimitive((Long[])((Long[])array));
        }
        if (array instanceof Short[]) {
            return ArrayUtils.toPrimitive((Short[])((Short[])array));
        }
        if (array instanceof Byte[]) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])array));
        }
        if (array instanceof Character[]) {
            return ArrayUtils.toPrimitive((Character[])((Character[])array));
        }
        if (array instanceof Float[]) {
            return ArrayUtils.toPrimitive((Float[])((Float[])array));
        }
        if (array instanceof Double[]) {
            return ArrayUtils.toPrimitive((Double[])((Double[])array));
        }
        if (array instanceof Boolean[]) {
            return ArrayUtils.toPrimitive((Boolean[])((Boolean[])array));
        }
        if (array instanceof Object[]) {
            Object[] objectArray = (Object[])array;
            if (objectArray.length == 0) {
                return array;
            }
            Object firstElement = objectArray[0];
            if (firstElement == null) {
                return array;
            }
            if (firstElement instanceof Integer) {
                int[] newArray = new int[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = (Integer)objectArray[i];
                }
                return newArray;
            }
            if (firstElement instanceof Long) {
                long[] newArray = new long[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = (Long)objectArray[i];
                }
                return newArray;
            }
            if (firstElement instanceof Short) {
                short[] newArray = new short[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = (Short)objectArray[i];
                }
                return newArray;
            }
            if (firstElement instanceof Byte) {
                byte[] newArray = new byte[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = (Byte)objectArray[i];
                }
                return newArray;
            }
            if (firstElement instanceof Character) {
                char[] newArray = new char[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = ((Character)objectArray[i]).charValue();
                }
                return newArray;
            }
            if (firstElement instanceof Float) {
                float[] newArray = new float[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = ((Float)objectArray[i]).floatValue();
                }
                return newArray;
            }
            if (firstElement instanceof Double) {
                double[] newArray = new double[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = (Double)objectArray[i];
                }
                return newArray;
            }
            if (firstElement instanceof Boolean) {
                boolean[] newArray = new boolean[objectArray.length];
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = (Boolean)objectArray[i];
                }
                return newArray;
            }
            throw new IllegalArgumentException("First element of array is of unhandled type " + array.getClass());
        }
        throw new IllegalArgumentException("Not an array, got object of type " + array.getClass());
    }
}

