/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.EqualityUtils;

public class DataSchema {
    private final String[] _columnNames;
    private final ColumnDataType[] _columnDataTypes;

    public DataSchema(String[] columnNames, ColumnDataType[] columnDataTypes) {
        this._columnNames = columnNames;
        this._columnDataTypes = columnDataTypes;
    }

    public int size() {
        return this._columnNames.length;
    }

    public String getColumnName(int index) {
        return this._columnNames[index];
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public ColumnDataType getColumnDataType(int index) {
        return this._columnDataTypes[index];
    }

    public ColumnDataType[] getColumnDataTypes() {
        return this._columnDataTypes;
    }

    public boolean isTypeCompatibleWith(DataSchema anotherDataSchema) {
        if (!Arrays.equals(this._columnNames, anotherDataSchema._columnNames)) {
            return false;
        }
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            if (this._columnDataTypes[i].isCompatible(anotherDataSchema._columnDataTypes[i])) continue;
            return false;
        }
        return true;
    }

    public void upgradeToCover(DataSchema anotherDataSchema) {
        int numColumns = this._columnDataTypes.length;
        for (int i = 0; i < numColumns; ++i) {
            ColumnDataType thisColumnDataType = this._columnDataTypes[i];
            ColumnDataType thatColumnDataType = anotherDataSchema._columnDataTypes[i];
            if (thisColumnDataType == thatColumnDataType) continue;
            if (thisColumnDataType.isArray()) {
                if (thisColumnDataType.isWholeNumberArray() && thatColumnDataType.isWholeNumberArray()) {
                    this._columnDataTypes[i] = ColumnDataType.LONG_ARRAY;
                    continue;
                }
                this._columnDataTypes[i] = ColumnDataType.DOUBLE_ARRAY;
                continue;
            }
            this._columnDataTypes[i] = thisColumnDataType.isWholeNumber() && thatColumnDataType.isWholeNumber() ? ColumnDataType.LONG : ColumnDataType.DOUBLE;
        }
    }

    public byte[] toBytes() throws IOException {
        byte[] bytes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int length = this._columnNames.length;
        dataOutputStream.writeInt(length);
        for (String string : this._columnNames) {
            bytes = StringUtil.encodeUtf8(string);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        for (ColumnDataType columnDataType : this._columnDataTypes) {
            bytes = StringUtil.encodeUtf8(columnDataType.name());
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static DataSchema fromBytes(byte[] buffer) throws IOException {
        int readLength;
        byte[] bytes;
        int length;
        int i;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int numColumns = dataInputStream.readInt();
        String[] columnNames = new String[numColumns];
        ColumnDataType[] columnDataTypes = new ColumnDataType[numColumns];
        for (i = 0; i < numColumns; ++i) {
            length = dataInputStream.readInt();
            bytes = new byte[length];
            readLength = dataInputStream.read(bytes);
            assert (readLength == length);
            columnNames[i] = StringUtil.decodeUtf8(bytes);
        }
        for (i = 0; i < numColumns; ++i) {
            length = dataInputStream.readInt();
            bytes = new byte[length];
            readLength = dataInputStream.read(bytes);
            assert (readLength == length);
            columnDataTypes[i] = ColumnDataType.valueOf(StringUtil.decodeUtf8(bytes));
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    public DataSchema clone() {
        return new DataSchema((String[])this._columnNames.clone(), (ColumnDataType[])this._columnDataTypes.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            stringBuilder.append(this._columnNames[i]).append('(').append((Object)this._columnDataTypes[i]).append(')').append(',');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        return stringBuilder.toString();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof DataSchema) {
            DataSchema anotherDataSchema = (DataSchema)anObject;
            return Arrays.equals(this._columnNames, anotherDataSchema._columnNames) && Arrays.equals((Object[])this._columnDataTypes, (Object[])anotherDataSchema._columnDataTypes);
        }
        return false;
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf((int)Arrays.hashCode(this._columnNames), (int)Arrays.hashCode((Object[])this._columnDataTypes));
    }

    public static enum ColumnDataType {
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        BYTES,
        OBJECT,
        INT_ARRAY,
        LONG_ARRAY,
        FLOAT_ARRAY,
        DOUBLE_ARRAY,
        STRING_ARRAY;


        public boolean isNumber() {
            return this == INT || this == LONG || this == FLOAT || this == DOUBLE;
        }

        public boolean isWholeNumber() {
            return this == INT || this == LONG;
        }

        public boolean isArray() {
            return this == INT_ARRAY || this == LONG_ARRAY || this == FLOAT_ARRAY || this == DOUBLE_ARRAY || this == STRING_ARRAY;
        }

        public boolean isNumberArray() {
            return this == INT_ARRAY || this == LONG_ARRAY || this == FLOAT_ARRAY || this == DOUBLE_ARRAY;
        }

        public boolean isWholeNumberArray() {
            return this == INT_ARRAY || this == LONG_ARRAY;
        }

        public boolean isCompatible(ColumnDataType anotherColumnDataType) {
            return this == anotherColumnDataType || this.isNumber() && anotherColumnDataType.isNumber() || this.isNumberArray() && anotherColumnDataType.isNumberArray();
        }

        public static ColumnDataType fromDataType(FieldSpec.DataType dataType, boolean isSingleValue) {
            return isSingleValue ? ColumnDataType.fromDataTypeSV(dataType) : ColumnDataType.fromDataTypeMV(dataType);
        }

        public static ColumnDataType fromDataTypeSV(FieldSpec.DataType dataType) {
            switch (dataType) {
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case STRING: {
                    return STRING;
                }
                case BYTES: {
                    return BYTES;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }

        public static ColumnDataType fromDataTypeMV(FieldSpec.DataType dataType) {
            switch (dataType) {
                case INT: {
                    return INT_ARRAY;
                }
                case LONG: {
                    return LONG_ARRAY;
                }
                case FLOAT: {
                    return FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return DOUBLE_ARRAY;
                }
                case STRING: {
                    return STRING_ARRAY;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }
    }
}

