/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response.broker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.AggregationResult;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonPropertyOrder(value={"selectionResults", "aggregationResults", "resultTable", "exceptions", "numServersQueried", "numServersResponded", "numSegmentsQueried", "numSegmentsProcessed", "numSegmentsMatched", "numConsumingSegmentsQueried", "numDocsScanned", "numEntriesScannedInFilter", "numEntriesScannedPostFilter", "numGroupsLimitReached", "totalDocs", "timeUsedMs", "segmentStatistics", "traceInfo"})
public class BrokerResponseNative
implements BrokerResponse {
    public static final BrokerResponseNative EMPTY_RESULT = BrokerResponseNative.empty();
    public static final BrokerResponseNative NO_TABLE_RESULT = new BrokerResponseNative(QueryException.BROKER_RESOURCE_MISSING_ERROR);
    private int _numServersQueried = 0;
    private int _numServersResponded = 0;
    private long _numDocsScanned = 0L;
    private long _numEntriesScannedInFilter = 0L;
    private long _numEntriesScannedPostFilter = 0L;
    private long _numSegmentsQueried = 0L;
    private long _numSegmentsProcessed = 0L;
    private long _numSegmentsMatched = 0L;
    private long _numConsumingSegmentsQueried = 0L;
    private long _minConsumingFreshnessTimeMs = 0L;
    private long _totalDocs = 0L;
    private boolean _numGroupsLimitReached = false;
    private long _timeUsedMs = 0L;
    private SelectionResults _selectionResults;
    private List<AggregationResult> _aggregationResults;
    private ResultTable _resultTable;
    private Map<String, String> _traceInfo = new HashMap<String, String>();
    private List<QueryProcessingException> _processingExceptions = new ArrayList<QueryProcessingException>();
    private List<String> _segmentStatistics = new ArrayList<String>();

    public BrokerResponseNative() {
    }

    public BrokerResponseNative(ProcessingException exception) {
        this._processingExceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
    }

    public BrokerResponseNative(List<ProcessingException> exceptions) {
        for (ProcessingException exception : exceptions) {
            this._processingExceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
        }
    }

    public static BrokerResponseNative empty() {
        return new BrokerResponseNative();
    }

    @JsonProperty(value="selectionResults")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SelectionResults getSelectionResults() {
        return this._selectionResults;
    }

    @JsonProperty(value="selectionResults")
    public void setSelectionResults(SelectionResults selectionResults) {
        this._selectionResults = selectionResults;
    }

    @JsonProperty(value="aggregationResults")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AggregationResult> getAggregationResults() {
        return this._aggregationResults;
    }

    @JsonProperty(value="aggregationResults")
    public void setAggregationResults(List<AggregationResult> aggregationResults) {
        this._aggregationResults = aggregationResults;
    }

    @JsonProperty(value="resultTable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ResultTable getResultTable() {
        return this._resultTable;
    }

    @JsonProperty(value="resultTable")
    public void setResultTable(ResultTable resultTable) {
        this._resultTable = resultTable;
    }

    @Override
    @JsonProperty(value="exceptions")
    public List<QueryProcessingException> getProcessingExceptions() {
        return this._processingExceptions;
    }

    @JsonProperty(value="exceptions")
    public void setProcessingExceptions(List<QueryProcessingException> processingExceptions) {
        this._processingExceptions = processingExceptions;
    }

    @Override
    @JsonProperty(value="numServersQueried")
    public int getNumServersQueried() {
        return this._numServersQueried;
    }

    @Override
    @JsonProperty(value="numServersQueried")
    public void setNumServersQueried(int numServersQueried) {
        this._numServersQueried = numServersQueried;
    }

    @Override
    @JsonProperty(value="numServersResponded")
    public int getNumServersResponded() {
        return this._numServersResponded;
    }

    @Override
    @JsonProperty(value="numServersResponded")
    public void setNumServersResponded(int numServersResponded) {
        this._numServersResponded = numServersResponded;
    }

    @Override
    @JsonProperty(value="numDocsScanned")
    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    @JsonProperty(value="numDocsScanned")
    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    @Override
    @JsonProperty(value="numEntriesScannedInFilter")
    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    @JsonProperty(value="numEntriesScannedInFilter")
    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    @Override
    @JsonProperty(value="numEntriesScannedPostFilter")
    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    @JsonProperty(value="numEntriesScannedPostFilter")
    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    @Override
    @JsonProperty(value="numSegmentsQueried")
    public long getNumSegmentsQueried() {
        return this._numSegmentsQueried;
    }

    @JsonProperty(value="numSegmentsQueried")
    public void setNumSegmentsQueried(long numSegmentsQueried) {
        this._numSegmentsQueried = numSegmentsQueried;
    }

    @Override
    @JsonProperty(value="numSegmentsProcessed")
    public long getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    @JsonProperty(value="numSegmentsProcessed")
    public void setNumSegmentsProcessed(long numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    @Override
    @JsonProperty(value="numSegmentsMatched")
    public long getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    @JsonProperty(value="numSegmentsMatched")
    public void setNumSegmentsMatched(long numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    @Override
    @JsonProperty(value="numConsumingSegmentsQueried")
    public long getNumConsumingSegmentsQueried() {
        return this._numConsumingSegmentsQueried;
    }

    @JsonProperty(value="numConsumingSegmentsQueried")
    public void setNumConsumingSegmentsQueried(long numConsumingSegmentsQueried) {
        this._numConsumingSegmentsQueried = numConsumingSegmentsQueried;
    }

    @Override
    @JsonProperty(value="minConsumingFreshnessTimeMs")
    public long getMinConsumingFreshnessTimeMs() {
        return this._minConsumingFreshnessTimeMs;
    }

    @JsonProperty(value="minConsumingFreshnessTimeMs")
    public void setMinConsumingFreshnessTimeMs(long minConsumingFreshnessTimeMs) {
        this._minConsumingFreshnessTimeMs = minConsumingFreshnessTimeMs;
    }

    @Override
    @JsonProperty(value="totalDocs")
    public long getTotalDocs() {
        return this._totalDocs;
    }

    @JsonProperty(value="totalDocs")
    public void setTotalDocs(long totalDocs) {
        this._totalDocs = totalDocs;
    }

    @Override
    @JsonProperty(value="numGroupsLimitReached")
    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    @JsonProperty(value="numGroupsLimitReached")
    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    @JsonProperty(value="timeUsedMs")
    public long getTimeUsedMs() {
        return this._timeUsedMs;
    }

    @Override
    @JsonProperty(value="timeUsedMs")
    public void setTimeUsedMs(long timeUsedMs) {
        this._timeUsedMs = timeUsedMs;
    }

    @JsonProperty(value="segmentStatistics")
    public List<String> getSegmentStatistics() {
        return this._segmentStatistics;
    }

    @JsonProperty(value="segmentStatistics")
    public void setSegmentStatistics(List<String> segmentStatistics) {
        this._segmentStatistics = segmentStatistics;
    }

    @JsonProperty(value="traceInfo")
    public Map<String, String> getTraceInfo() {
        return this._traceInfo;
    }

    @JsonProperty(value="traceInfo")
    public void setTraceInfo(Map<String, String> traceInfo) {
        this._traceInfo = traceInfo;
    }

    @Override
    public String toJsonString() throws IOException {
        return JsonUtils.objectToString((Object)this);
    }

    public static BrokerResponseNative fromJsonString(String jsonString) throws IOException {
        return (BrokerResponseNative)JsonUtils.stringToObject((String)jsonString, BrokerResponseNative.class);
    }

    @Override
    @JsonIgnore
    public void setExceptions(List<ProcessingException> exceptions) {
        for (ProcessingException exception : exceptions) {
            this._processingExceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
        }
    }

    public void addToExceptions(QueryProcessingException processingException) {
        this._processingExceptions.add(processingException);
    }

    @Override
    @JsonIgnore
    public int getExceptionsSize() {
        return this._processingExceptions.size();
    }
}

