/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.spi.utils.EqualityUtils;

public class TransformExpressionTree {
    private static final Pql2Compiler COMPILER = new Pql2Compiler();
    private final ExpressionType _expressionType;
    private String _value;
    private final List<TransformExpressionTree> _children;

    public static TransformExpressionTree compileToExpressionTree(String expression) {
        return COMPILER.compileToExpressionTree(expression);
    }

    public static String standardizeExpression(String expression) {
        return TransformExpressionTree.compileToExpressionTree(expression).toString();
    }

    public static String getStandardExpression(AstNode astNode) {
        if (astNode instanceof IdentifierAstNode) {
            return ((IdentifierAstNode)astNode).getName();
        }
        if (astNode instanceof FunctionCallAstNode) {
            return TransformExpressionTree.standardizeExpression(((FunctionCallAstNode)astNode).getExpression());
        }
        if (astNode instanceof LiteralAstNode) {
            return ((LiteralAstNode)astNode).getValueAsString();
        }
        throw new IllegalStateException("Cannot get standard expression from " + astNode.getClass().getSimpleName());
    }

    public TransformExpressionTree(AstNode root) {
        if (root instanceof FunctionCallAstNode) {
            this._expressionType = ExpressionType.FUNCTION;
            this._value = ((FunctionCallAstNode)root).getName().toLowerCase();
            this._children = new ArrayList<TransformExpressionTree>();
            if (root.hasChildren()) {
                for (AstNode astNode : root.getChildren()) {
                    this._children.add(new TransformExpressionTree(astNode));
                }
            }
        } else if (root instanceof IdentifierAstNode) {
            this._expressionType = ExpressionType.IDENTIFIER;
            this._value = ((IdentifierAstNode)root).getName();
            this._children = null;
        } else if (root instanceof LiteralAstNode) {
            this._expressionType = ExpressionType.LITERAL;
            this._value = ((LiteralAstNode)root).getValueAsString();
            this._children = null;
        } else {
            throw new IllegalArgumentException("Illegal AstNode type for TransformExpressionTree: " + root.getClass().getName());
        }
    }

    public TransformExpressionTree(ExpressionType expressionType, String value, @Nullable List<TransformExpressionTree> children) {
        this._expressionType = expressionType;
        this._value = value;
        this._children = children;
    }

    public ExpressionType getExpressionType() {
        return this._expressionType;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public List<TransformExpressionTree> getChildren() {
        return this._children;
    }

    public boolean isColumn() {
        return this._expressionType == ExpressionType.IDENTIFIER;
    }

    public boolean isFunction() {
        return this._expressionType == ExpressionType.FUNCTION;
    }

    public boolean isLiteral() {
        return this._expressionType == ExpressionType.LITERAL;
    }

    public void getColumns(Set<String> columns) {
        if (this._expressionType == ExpressionType.IDENTIFIER) {
            columns.add(this._value);
        } else if (this._children != null) {
            for (TransformExpressionTree child : this._children) {
                child.getColumns(columns);
            }
        }
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf((int)EqualityUtils.hashCodeOf((int)this._expressionType.hashCode(), (Object)this._value), this._children);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformExpressionTree) {
            TransformExpressionTree that = (TransformExpressionTree)obj;
            return this._expressionType == that._expressionType && this._value.equals(that._value) && Objects.equals(this._children, that._children);
        }
        return false;
    }

    public String toString() {
        switch (this._expressionType) {
            case FUNCTION: {
                StringBuilder builder = new StringBuilder(this._value).append('(');
                int numChildren = this._children.size();
                for (int i = 0; i < numChildren; ++i) {
                    builder.append(this._children.get(i).toString());
                    if (i != numChildren - 1) {
                        builder.append(',');
                        continue;
                    }
                    builder.append(')');
                }
                return builder.toString();
            }
            case IDENTIFIER: {
                return this._value;
            }
            case LITERAL: {
                return "'" + this._value + "'";
            }
        }
        throw new IllegalStateException();
    }

    public static enum ExpressionType {
        FUNCTION,
        IDENTIFIER,
        LITERAL;

    }
}

