/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class PinotQuery
implements TBase<PinotQuery, _Fields>,
Serializable,
Cloneable,
Comparable<PinotQuery> {
    private static final TStruct STRUCT_DESC = new TStruct("PinotQuery");
    private static final TField VERSION_FIELD_DESC = new TField("version", 8, 1);
    private static final TField DATA_SOURCE_FIELD_DESC = new TField("dataSource", 12, 2);
    private static final TField SELECT_LIST_FIELD_DESC = new TField("selectList", 15, 3);
    private static final TField FILTER_EXPRESSION_FIELD_DESC = new TField("filterExpression", 12, 4);
    private static final TField GROUP_BY_LIST_FIELD_DESC = new TField("groupByList", 15, 5);
    private static final TField ORDER_BY_LIST_FIELD_DESC = new TField("orderByList", 15, 6);
    private static final TField HAVING_EXPRESSION_FIELD_DESC = new TField("havingExpression", 12, 7);
    private static final TField LIMIT_FIELD_DESC = new TField("limit", 8, 8);
    private static final TField OFFSET_FIELD_DESC = new TField("offset", 8, 9);
    private static final TField DEBUG_OPTIONS_FIELD_DESC = new TField("debugOptions", 13, 10);
    private static final TField QUERY_OPTIONS_FIELD_DESC = new TField("queryOptions", 13, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PinotQueryStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PinotQueryTupleSchemeFactory();
    public int version;
    @Nullable
    public DataSource dataSource;
    @Nullable
    public List<Expression> selectList;
    @Nullable
    public Expression filterExpression;
    @Nullable
    public List<Expression> groupByList;
    @Nullable
    public List<Expression> orderByList;
    @Nullable
    public Expression havingExpression;
    public int limit;
    public int offset;
    @Nullable
    public Map<String, String> debugOptions;
    @Nullable
    public Map<String, String> queryOptions;
    private static final int __VERSION_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private static final int __OFFSET_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.VERSION, _Fields.DATA_SOURCE, _Fields.SELECT_LIST, _Fields.FILTER_EXPRESSION, _Fields.GROUP_BY_LIST, _Fields.ORDER_BY_LIST, _Fields.HAVING_EXPRESSION, _Fields.LIMIT, _Fields.OFFSET, _Fields.DEBUG_OPTIONS, _Fields.QUERY_OPTIONS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PinotQuery() {
        this.limit = 10;
        this.offset = 0;
    }

    public PinotQuery(PinotQuery other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.version = other.version;
        if (other.isSetDataSource()) {
            this.dataSource = new DataSource(other.dataSource);
        }
        if (other.isSetSelectList()) {
            ArrayList<Expression> __this__selectList = new ArrayList<Expression>(other.selectList.size());
            for (Expression other_element : other.selectList) {
                __this__selectList.add(new Expression(other_element));
            }
            this.selectList = __this__selectList;
        }
        if (other.isSetFilterExpression()) {
            this.filterExpression = new Expression(other.filterExpression);
        }
        if (other.isSetGroupByList()) {
            ArrayList<Expression> __this__groupByList = new ArrayList<Expression>(other.groupByList.size());
            for (Expression other_element : other.groupByList) {
                __this__groupByList.add(new Expression(other_element));
            }
            this.groupByList = __this__groupByList;
        }
        if (other.isSetOrderByList()) {
            ArrayList<Expression> __this__orderByList = new ArrayList<Expression>(other.orderByList.size());
            for (Expression other_element : other.orderByList) {
                __this__orderByList.add(new Expression(other_element));
            }
            this.orderByList = __this__orderByList;
        }
        if (other.isSetHavingExpression()) {
            this.havingExpression = new Expression(other.havingExpression);
        }
        this.limit = other.limit;
        this.offset = other.offset;
        if (other.isSetDebugOptions()) {
            HashMap<String, String> __this__debugOptions = new HashMap<String, String>(other.debugOptions);
            this.debugOptions = __this__debugOptions;
        }
        if (other.isSetQueryOptions()) {
            HashMap<String, String> __this__queryOptions = new HashMap<String, String>(other.queryOptions);
            this.queryOptions = __this__queryOptions;
        }
    }

    public PinotQuery deepCopy() {
        return new PinotQuery(this);
    }

    public void clear() {
        this.setVersionIsSet(false);
        this.version = 0;
        this.dataSource = null;
        this.selectList = null;
        this.filterExpression = null;
        this.groupByList = null;
        this.orderByList = null;
        this.havingExpression = null;
        this.limit = 10;
        this.offset = 0;
        this.debugOptions = null;
        this.queryOptions = null;
    }

    public int getVersion() {
        return this.version;
    }

    public PinotQuery setVersion(int version) {
        this.version = version;
        this.setVersionIsSet(true);
        return this;
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public PinotQuery setDataSource(@Nullable DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public void unsetDataSource() {
        this.dataSource = null;
    }

    public boolean isSetDataSource() {
        return this.dataSource != null;
    }

    public void setDataSourceIsSet(boolean value) {
        if (!value) {
            this.dataSource = null;
        }
    }

    public int getSelectListSize() {
        return this.selectList == null ? 0 : this.selectList.size();
    }

    @Nullable
    public Iterator<Expression> getSelectListIterator() {
        return this.selectList == null ? null : this.selectList.iterator();
    }

    public void addToSelectList(Expression elem) {
        if (this.selectList == null) {
            this.selectList = new ArrayList<Expression>();
        }
        this.selectList.add(elem);
    }

    @Nullable
    public List<Expression> getSelectList() {
        return this.selectList;
    }

    public PinotQuery setSelectList(@Nullable List<Expression> selectList) {
        this.selectList = selectList;
        return this;
    }

    public void unsetSelectList() {
        this.selectList = null;
    }

    public boolean isSetSelectList() {
        return this.selectList != null;
    }

    public void setSelectListIsSet(boolean value) {
        if (!value) {
            this.selectList = null;
        }
    }

    @Nullable
    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public PinotQuery setFilterExpression(@Nullable Expression filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public void unsetFilterExpression() {
        this.filterExpression = null;
    }

    public boolean isSetFilterExpression() {
        return this.filterExpression != null;
    }

    public void setFilterExpressionIsSet(boolean value) {
        if (!value) {
            this.filterExpression = null;
        }
    }

    public int getGroupByListSize() {
        return this.groupByList == null ? 0 : this.groupByList.size();
    }

    @Nullable
    public Iterator<Expression> getGroupByListIterator() {
        return this.groupByList == null ? null : this.groupByList.iterator();
    }

    public void addToGroupByList(Expression elem) {
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<Expression>();
        }
        this.groupByList.add(elem);
    }

    @Nullable
    public List<Expression> getGroupByList() {
        return this.groupByList;
    }

    public PinotQuery setGroupByList(@Nullable List<Expression> groupByList) {
        this.groupByList = groupByList;
        return this;
    }

    public void unsetGroupByList() {
        this.groupByList = null;
    }

    public boolean isSetGroupByList() {
        return this.groupByList != null;
    }

    public void setGroupByListIsSet(boolean value) {
        if (!value) {
            this.groupByList = null;
        }
    }

    public int getOrderByListSize() {
        return this.orderByList == null ? 0 : this.orderByList.size();
    }

    @Nullable
    public Iterator<Expression> getOrderByListIterator() {
        return this.orderByList == null ? null : this.orderByList.iterator();
    }

    public void addToOrderByList(Expression elem) {
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<Expression>();
        }
        this.orderByList.add(elem);
    }

    @Nullable
    public List<Expression> getOrderByList() {
        return this.orderByList;
    }

    public PinotQuery setOrderByList(@Nullable List<Expression> orderByList) {
        this.orderByList = orderByList;
        return this;
    }

    public void unsetOrderByList() {
        this.orderByList = null;
    }

    public boolean isSetOrderByList() {
        return this.orderByList != null;
    }

    public void setOrderByListIsSet(boolean value) {
        if (!value) {
            this.orderByList = null;
        }
    }

    @Nullable
    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public PinotQuery setHavingExpression(@Nullable Expression havingExpression) {
        this.havingExpression = havingExpression;
        return this;
    }

    public void unsetHavingExpression() {
        this.havingExpression = null;
    }

    public boolean isSetHavingExpression() {
        return this.havingExpression != null;
    }

    public void setHavingExpressionIsSet(boolean value) {
        if (!value) {
            this.havingExpression = null;
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public PinotQuery setLimit(int limit) {
        this.limit = limit;
        this.setLimitIsSet(true);
        return this;
    }

    public void unsetLimit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLimit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLimitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getOffset() {
        return this.offset;
    }

    public PinotQuery setOffset(int offset) {
        this.offset = offset;
        this.setOffsetIsSet(true);
        return this;
    }

    public void unsetOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getDebugOptionsSize() {
        return this.debugOptions == null ? 0 : this.debugOptions.size();
    }

    public void putToDebugOptions(String key, String val) {
        if (this.debugOptions == null) {
            this.debugOptions = new HashMap<String, String>();
        }
        this.debugOptions.put(key, val);
    }

    @Nullable
    public Map<String, String> getDebugOptions() {
        return this.debugOptions;
    }

    public PinotQuery setDebugOptions(@Nullable Map<String, String> debugOptions) {
        this.debugOptions = debugOptions;
        return this;
    }

    public void unsetDebugOptions() {
        this.debugOptions = null;
    }

    public boolean isSetDebugOptions() {
        return this.debugOptions != null;
    }

    public void setDebugOptionsIsSet(boolean value) {
        if (!value) {
            this.debugOptions = null;
        }
    }

    public int getQueryOptionsSize() {
        return this.queryOptions == null ? 0 : this.queryOptions.size();
    }

    public void putToQueryOptions(String key, String val) {
        if (this.queryOptions == null) {
            this.queryOptions = new HashMap<String, String>();
        }
        this.queryOptions.put(key, val);
    }

    @Nullable
    public Map<String, String> getQueryOptions() {
        return this.queryOptions;
    }

    public PinotQuery setQueryOptions(@Nullable Map<String, String> queryOptions) {
        this.queryOptions = queryOptions;
        return this;
    }

    public void unsetQueryOptions() {
        this.queryOptions = null;
    }

    public boolean isSetQueryOptions() {
        return this.queryOptions != null;
    }

    public void setQueryOptionsIsSet(boolean value) {
        if (!value) {
            this.queryOptions = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Integer)value);
                break;
            }
            case DATA_SOURCE: {
                if (value == null) {
                    this.unsetDataSource();
                    break;
                }
                this.setDataSource((DataSource)value);
                break;
            }
            case SELECT_LIST: {
                if (value == null) {
                    this.unsetSelectList();
                    break;
                }
                this.setSelectList((List)value);
                break;
            }
            case FILTER_EXPRESSION: {
                if (value == null) {
                    this.unsetFilterExpression();
                    break;
                }
                this.setFilterExpression((Expression)value);
                break;
            }
            case GROUP_BY_LIST: {
                if (value == null) {
                    this.unsetGroupByList();
                    break;
                }
                this.setGroupByList((List)value);
                break;
            }
            case ORDER_BY_LIST: {
                if (value == null) {
                    this.unsetOrderByList();
                    break;
                }
                this.setOrderByList((List)value);
                break;
            }
            case HAVING_EXPRESSION: {
                if (value == null) {
                    this.unsetHavingExpression();
                    break;
                }
                this.setHavingExpression((Expression)value);
                break;
            }
            case LIMIT: {
                if (value == null) {
                    this.unsetLimit();
                    break;
                }
                this.setLimit((Integer)value);
                break;
            }
            case OFFSET: {
                if (value == null) {
                    this.unsetOffset();
                    break;
                }
                this.setOffset((Integer)value);
                break;
            }
            case DEBUG_OPTIONS: {
                if (value == null) {
                    this.unsetDebugOptions();
                    break;
                }
                this.setDebugOptions((Map)value);
                break;
            }
            case QUERY_OPTIONS: {
                if (value == null) {
                    this.unsetQueryOptions();
                    break;
                }
                this.setQueryOptions((Map)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VERSION: {
                return this.getVersion();
            }
            case DATA_SOURCE: {
                return this.getDataSource();
            }
            case SELECT_LIST: {
                return this.getSelectList();
            }
            case FILTER_EXPRESSION: {
                return this.getFilterExpression();
            }
            case GROUP_BY_LIST: {
                return this.getGroupByList();
            }
            case ORDER_BY_LIST: {
                return this.getOrderByList();
            }
            case HAVING_EXPRESSION: {
                return this.getHavingExpression();
            }
            case LIMIT: {
                return this.getLimit();
            }
            case OFFSET: {
                return this.getOffset();
            }
            case DEBUG_OPTIONS: {
                return this.getDebugOptions();
            }
            case QUERY_OPTIONS: {
                return this.getQueryOptions();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VERSION: {
                return this.isSetVersion();
            }
            case DATA_SOURCE: {
                return this.isSetDataSource();
            }
            case SELECT_LIST: {
                return this.isSetSelectList();
            }
            case FILTER_EXPRESSION: {
                return this.isSetFilterExpression();
            }
            case GROUP_BY_LIST: {
                return this.isSetGroupByList();
            }
            case ORDER_BY_LIST: {
                return this.isSetOrderByList();
            }
            case HAVING_EXPRESSION: {
                return this.isSetHavingExpression();
            }
            case LIMIT: {
                return this.isSetLimit();
            }
            case OFFSET: {
                return this.isSetOffset();
            }
            case DEBUG_OPTIONS: {
                return this.isSetDebugOptions();
            }
            case QUERY_OPTIONS: {
                return this.isSetQueryOptions();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof PinotQuery) {
            return this.equals((PinotQuery)that);
        }
        return false;
    }

    public boolean equals(PinotQuery that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_version = this.isSetVersion();
        boolean that_present_version = that.isSetVersion();
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_dataSource = this.isSetDataSource();
        boolean that_present_dataSource = that.isSetDataSource();
        if (this_present_dataSource || that_present_dataSource) {
            if (!this_present_dataSource || !that_present_dataSource) {
                return false;
            }
            if (!this.dataSource.equals(that.dataSource)) {
                return false;
            }
        }
        boolean this_present_selectList = this.isSetSelectList();
        boolean that_present_selectList = that.isSetSelectList();
        if (this_present_selectList || that_present_selectList) {
            if (!this_present_selectList || !that_present_selectList) {
                return false;
            }
            if (!this.selectList.equals(that.selectList)) {
                return false;
            }
        }
        boolean this_present_filterExpression = this.isSetFilterExpression();
        boolean that_present_filterExpression = that.isSetFilterExpression();
        if (this_present_filterExpression || that_present_filterExpression) {
            if (!this_present_filterExpression || !that_present_filterExpression) {
                return false;
            }
            if (!this.filterExpression.equals(that.filterExpression)) {
                return false;
            }
        }
        boolean this_present_groupByList = this.isSetGroupByList();
        boolean that_present_groupByList = that.isSetGroupByList();
        if (this_present_groupByList || that_present_groupByList) {
            if (!this_present_groupByList || !that_present_groupByList) {
                return false;
            }
            if (!this.groupByList.equals(that.groupByList)) {
                return false;
            }
        }
        boolean this_present_orderByList = this.isSetOrderByList();
        boolean that_present_orderByList = that.isSetOrderByList();
        if (this_present_orderByList || that_present_orderByList) {
            if (!this_present_orderByList || !that_present_orderByList) {
                return false;
            }
            if (!this.orderByList.equals(that.orderByList)) {
                return false;
            }
        }
        boolean this_present_havingExpression = this.isSetHavingExpression();
        boolean that_present_havingExpression = that.isSetHavingExpression();
        if (this_present_havingExpression || that_present_havingExpression) {
            if (!this_present_havingExpression || !that_present_havingExpression) {
                return false;
            }
            if (!this.havingExpression.equals(that.havingExpression)) {
                return false;
            }
        }
        boolean this_present_limit = this.isSetLimit();
        boolean that_present_limit = that.isSetLimit();
        if (this_present_limit || that_present_limit) {
            if (!this_present_limit || !that_present_limit) {
                return false;
            }
            if (this.limit != that.limit) {
                return false;
            }
        }
        boolean this_present_offset = this.isSetOffset();
        boolean that_present_offset = that.isSetOffset();
        if (this_present_offset || that_present_offset) {
            if (!this_present_offset || !that_present_offset) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
        }
        boolean this_present_debugOptions = this.isSetDebugOptions();
        boolean that_present_debugOptions = that.isSetDebugOptions();
        if (this_present_debugOptions || that_present_debugOptions) {
            if (!this_present_debugOptions || !that_present_debugOptions) {
                return false;
            }
            if (!this.debugOptions.equals(that.debugOptions)) {
                return false;
            }
        }
        boolean this_present_queryOptions = this.isSetQueryOptions();
        boolean that_present_queryOptions = that.isSetQueryOptions();
        if (this_present_queryOptions || that_present_queryOptions) {
            if (!this_present_queryOptions || !that_present_queryOptions) {
                return false;
            }
            if (!this.queryOptions.equals(that.queryOptions)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetVersion() ? 131071 : 524287);
        if (this.isSetVersion()) {
            hashCode = hashCode * 8191 + this.version;
        }
        hashCode = hashCode * 8191 + (this.isSetDataSource() ? 131071 : 524287);
        if (this.isSetDataSource()) {
            hashCode = hashCode * 8191 + this.dataSource.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSelectList() ? 131071 : 524287);
        if (this.isSetSelectList()) {
            hashCode = hashCode * 8191 + this.selectList.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFilterExpression() ? 131071 : 524287);
        if (this.isSetFilterExpression()) {
            hashCode = hashCode * 8191 + this.filterExpression.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetGroupByList() ? 131071 : 524287);
        if (this.isSetGroupByList()) {
            hashCode = hashCode * 8191 + this.groupByList.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOrderByList() ? 131071 : 524287);
        if (this.isSetOrderByList()) {
            hashCode = hashCode * 8191 + this.orderByList.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetHavingExpression() ? 131071 : 524287);
        if (this.isSetHavingExpression()) {
            hashCode = hashCode * 8191 + this.havingExpression.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLimit() ? 131071 : 524287);
        if (this.isSetLimit()) {
            hashCode = hashCode * 8191 + this.limit;
        }
        hashCode = hashCode * 8191 + (this.isSetOffset() ? 131071 : 524287);
        if (this.isSetOffset()) {
            hashCode = hashCode * 8191 + this.offset;
        }
        hashCode = hashCode * 8191 + (this.isSetDebugOptions() ? 131071 : 524287);
        if (this.isSetDebugOptions()) {
            hashCode = hashCode * 8191 + this.debugOptions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetQueryOptions() ? 131071 : 524287);
        if (this.isSetQueryOptions()) {
            hashCode = hashCode * 8191 + this.queryOptions.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(PinotQuery other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo((int)this.version, (int)other.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDataSource()).compareTo(other.isSetDataSource());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataSource() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dataSource, (Comparable)other.dataSource)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSelectList()).compareTo(other.isSetSelectList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSelectList() && (lastComparison = TBaseHelper.compareTo(this.selectList, other.selectList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFilterExpression()).compareTo(other.isSetFilterExpression());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFilterExpression() && (lastComparison = TBaseHelper.compareTo((Comparable)this.filterExpression, (Comparable)other.filterExpression)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGroupByList()).compareTo(other.isSetGroupByList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGroupByList() && (lastComparison = TBaseHelper.compareTo(this.groupByList, other.groupByList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrderByList()).compareTo(other.isSetOrderByList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrderByList() && (lastComparison = TBaseHelper.compareTo(this.orderByList, other.orderByList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHavingExpression()).compareTo(other.isSetHavingExpression());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHavingExpression() && (lastComparison = TBaseHelper.compareTo((Comparable)this.havingExpression, (Comparable)other.havingExpression)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLimit()).compareTo(other.isSetLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLimit() && (lastComparison = TBaseHelper.compareTo((int)this.limit, (int)other.limit)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOffset()).compareTo(other.isSetOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffset() && (lastComparison = TBaseHelper.compareTo((int)this.offset, (int)other.offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDebugOptions()).compareTo(other.isSetDebugOptions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDebugOptions() && (lastComparison = TBaseHelper.compareTo(this.debugOptions, other.debugOptions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetQueryOptions()).compareTo(other.isSetQueryOptions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryOptions() && (lastComparison = TBaseHelper.compareTo(this.queryOptions, other.queryOptions)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        PinotQuery.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        PinotQuery.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PinotQuery(");
        boolean first = true;
        if (this.isSetVersion()) {
            sb.append("version:");
            sb.append(this.version);
            first = false;
        }
        if (this.isSetDataSource()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dataSource:");
            if (this.dataSource == null) {
                sb.append("null");
            } else {
                sb.append(this.dataSource);
            }
            first = false;
        }
        if (this.isSetSelectList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("selectList:");
            if (this.selectList == null) {
                sb.append("null");
            } else {
                sb.append(this.selectList);
            }
            first = false;
        }
        if (this.isSetFilterExpression()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("filterExpression:");
            if (this.filterExpression == null) {
                sb.append("null");
            } else {
                sb.append(this.filterExpression);
            }
            first = false;
        }
        if (this.isSetGroupByList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("groupByList:");
            if (this.groupByList == null) {
                sb.append("null");
            } else {
                sb.append(this.groupByList);
            }
            first = false;
        }
        if (this.isSetOrderByList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("orderByList:");
            if (this.orderByList == null) {
                sb.append("null");
            } else {
                sb.append(this.orderByList);
            }
            first = false;
        }
        if (this.isSetHavingExpression()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("havingExpression:");
            if (this.havingExpression == null) {
                sb.append("null");
            } else {
                sb.append(this.havingExpression);
            }
            first = false;
        }
        if (this.isSetLimit()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("limit:");
            sb.append(this.limit);
            first = false;
        }
        if (this.isSetOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("offset:");
            sb.append(this.offset);
            first = false;
        }
        if (this.isSetDebugOptions()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("debugOptions:");
            if (this.debugOptions == null) {
                sb.append("null");
            } else {
                sb.append(this.debugOptions);
            }
            first = false;
        }
        if (this.isSetQueryOptions()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("queryOptions:");
            if (this.queryOptions == null) {
                sb.append("null");
            } else {
                sb.append(this.queryOptions);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.dataSource != null) {
            this.dataSource.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DATA_SOURCE, new FieldMetaData("dataSource", 2, (FieldValueMetaData)new StructMetaData(12, DataSource.class)));
        tmpMap.put(_Fields.SELECT_LIST, new FieldMetaData("selectList", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "Expression"))));
        tmpMap.put(_Fields.FILTER_EXPRESSION, new FieldMetaData("filterExpression", 2, new FieldValueMetaData(12, "Expression")));
        tmpMap.put(_Fields.GROUP_BY_LIST, new FieldMetaData("groupByList", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "Expression"))));
        tmpMap.put(_Fields.ORDER_BY_LIST, new FieldMetaData("orderByList", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "Expression"))));
        tmpMap.put(_Fields.HAVING_EXPRESSION, new FieldMetaData("havingExpression", 2, new FieldValueMetaData(12, "Expression")));
        tmpMap.put(_Fields.LIMIT, new FieldMetaData("limit", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.OFFSET, new FieldMetaData("offset", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DEBUG_OPTIONS, new FieldMetaData("debugOptions", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.QUERY_OPTIONS, new FieldMetaData("queryOptions", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PinotQuery.class, metaDataMap);
    }

    private static class PinotQueryTupleScheme
    extends TupleScheme<PinotQuery> {
        private PinotQueryTupleScheme() {
        }

        public void write(TProtocol prot, PinotQuery struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetVersion()) {
                optionals.set(0);
            }
            if (struct.isSetDataSource()) {
                optionals.set(1);
            }
            if (struct.isSetSelectList()) {
                optionals.set(2);
            }
            if (struct.isSetFilterExpression()) {
                optionals.set(3);
            }
            if (struct.isSetGroupByList()) {
                optionals.set(4);
            }
            if (struct.isSetOrderByList()) {
                optionals.set(5);
            }
            if (struct.isSetHavingExpression()) {
                optionals.set(6);
            }
            if (struct.isSetLimit()) {
                optionals.set(7);
            }
            if (struct.isSetOffset()) {
                optionals.set(8);
            }
            if (struct.isSetDebugOptions()) {
                optionals.set(9);
            }
            if (struct.isSetQueryOptions()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetVersion()) {
                oprot.writeI32(struct.version);
            }
            if (struct.isSetDataSource()) {
                struct.dataSource.write((TProtocol)oprot);
            }
            if (struct.isSetSelectList()) {
                oprot.writeI32(struct.selectList.size());
                for (Expression expression : struct.selectList) {
                    expression.write((TProtocol)oprot);
                }
            }
            if (struct.isSetFilterExpression()) {
                struct.filterExpression.write((TProtocol)oprot);
            }
            if (struct.isSetGroupByList()) {
                oprot.writeI32(struct.groupByList.size());
                for (Expression expression : struct.groupByList) {
                    expression.write((TProtocol)oprot);
                }
            }
            if (struct.isSetOrderByList()) {
                oprot.writeI32(struct.orderByList.size());
                for (Expression expression : struct.orderByList) {
                    expression.write((TProtocol)oprot);
                }
            }
            if (struct.isSetHavingExpression()) {
                struct.havingExpression.write((TProtocol)oprot);
            }
            if (struct.isSetLimit()) {
                oprot.writeI32(struct.limit);
            }
            if (struct.isSetOffset()) {
                oprot.writeI32(struct.offset);
            }
            if (struct.isSetDebugOptions()) {
                oprot.writeI32(struct.debugOptions.size());
                for (Map.Entry entry : struct.debugOptions.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetQueryOptions()) {
                oprot.writeI32(struct.queryOptions.size());
                for (Map.Entry entry : struct.queryOptions.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
        }

        public void read(TProtocol prot, PinotQuery struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.version = iprot.readI32();
                struct.setVersionIsSet(true);
            }
            if (incoming.get(1)) {
                struct.dataSource = new DataSource();
                struct.dataSource.read((TProtocol)iprot);
                struct.setDataSourceIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list27 = new TList(12, iprot.readI32());
                struct.selectList = new ArrayList<Expression>(_list27.size);
                for (int _i29 = 0; _i29 < _list27.size; ++_i29) {
                    Expression _elem28 = new Expression();
                    _elem28.read((TProtocol)iprot);
                    struct.selectList.add(_elem28);
                }
                struct.setSelectListIsSet(true);
            }
            if (incoming.get(3)) {
                struct.filterExpression = new Expression();
                struct.filterExpression.read((TProtocol)iprot);
                struct.setFilterExpressionIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list30 = new TList(12, iprot.readI32());
                struct.groupByList = new ArrayList<Expression>(_list30.size);
                for (int _i32 = 0; _i32 < _list30.size; ++_i32) {
                    Expression _elem31 = new Expression();
                    _elem31.read((TProtocol)iprot);
                    struct.groupByList.add(_elem31);
                }
                struct.setGroupByListIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list33 = new TList(12, iprot.readI32());
                struct.orderByList = new ArrayList<Expression>(_list33.size);
                for (int _i35 = 0; _i35 < _list33.size; ++_i35) {
                    Expression _elem34 = new Expression();
                    _elem34.read((TProtocol)iprot);
                    struct.orderByList.add(_elem34);
                }
                struct.setOrderByListIsSet(true);
            }
            if (incoming.get(6)) {
                struct.havingExpression = new Expression();
                struct.havingExpression.read((TProtocol)iprot);
                struct.setHavingExpressionIsSet(true);
            }
            if (incoming.get(7)) {
                struct.limit = iprot.readI32();
                struct.setLimitIsSet(true);
            }
            if (incoming.get(8)) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
            }
            if (incoming.get(9)) {
                TMap _map36 = new TMap(11, 11, iprot.readI32());
                struct.debugOptions = new HashMap<String, String>(2 * _map36.size);
                for (int _i39 = 0; _i39 < _map36.size; ++_i39) {
                    String _key37 = iprot.readString();
                    String _val38 = iprot.readString();
                    struct.debugOptions.put(_key37, _val38);
                }
                struct.setDebugOptionsIsSet(true);
            }
            if (incoming.get(10)) {
                TMap _map40 = new TMap(11, 11, iprot.readI32());
                struct.queryOptions = new HashMap<String, String>(2 * _map40.size);
                for (int _i43 = 0; _i43 < _map40.size; ++_i43) {
                    String _key41 = iprot.readString();
                    String _val42 = iprot.readString();
                    struct.queryOptions.put(_key41, _val42);
                }
                struct.setQueryOptionsIsSet(true);
            }
        }
    }

    private static class PinotQueryTupleSchemeFactory
    implements SchemeFactory {
        private PinotQueryTupleSchemeFactory() {
        }

        public PinotQueryTupleScheme getScheme() {
            return new PinotQueryTupleScheme();
        }
    }

    private static class PinotQueryStandardScheme
    extends StandardScheme<PinotQuery> {
        private PinotQueryStandardScheme() {
        }

        public void read(TProtocol iprot, PinotQuery struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.version = iprot.readI32();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.dataSource = new DataSource();
                            struct.dataSource.read(iprot);
                            struct.setDataSourceIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.selectList = new ArrayList<Expression>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                Expression _elem1 = new Expression();
                                _elem1.read(iprot);
                                struct.selectList.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setSelectListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.filterExpression = new Expression();
                            struct.filterExpression.read(iprot);
                            struct.setFilterExpressionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.groupByList = new ArrayList<Expression>(_list3.size);
                            for (int _i5 = 0; _i5 < _list3.size; ++_i5) {
                                Expression _elem4 = new Expression();
                                _elem4.read(iprot);
                                struct.groupByList.add(_elem4);
                            }
                            iprot.readListEnd();
                            struct.setGroupByListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list6 = iprot.readListBegin();
                            struct.orderByList = new ArrayList<Expression>(_list6.size);
                            for (int _i8 = 0; _i8 < _list6.size; ++_i8) {
                                Expression _elem7 = new Expression();
                                _elem7.read(iprot);
                                struct.orderByList.add(_elem7);
                            }
                            iprot.readListEnd();
                            struct.setOrderByListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.havingExpression = new Expression();
                            struct.havingExpression.read(iprot);
                            struct.setHavingExpressionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.limit = iprot.readI32();
                            struct.setLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.offset = iprot.readI32();
                            struct.setOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 13) {
                            TMap _map9 = iprot.readMapBegin();
                            struct.debugOptions = new HashMap<String, String>(2 * _map9.size);
                            for (int _i12 = 0; _i12 < _map9.size; ++_i12) {
                                String _key10 = iprot.readString();
                                String _val11 = iprot.readString();
                                struct.debugOptions.put(_key10, _val11);
                            }
                            iprot.readMapEnd();
                            struct.setDebugOptionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 13) {
                            TMap _map13 = iprot.readMapBegin();
                            struct.queryOptions = new HashMap<String, String>(2 * _map13.size);
                            for (int _i16 = 0; _i16 < _map13.size; ++_i16) {
                                String _key14 = iprot.readString();
                                String _val15 = iprot.readString();
                                struct.queryOptions.put(_key14, _val15);
                            }
                            iprot.readMapEnd();
                            struct.setQueryOptionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, PinotQuery struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.isSetVersion()) {
                oprot.writeFieldBegin(VERSION_FIELD_DESC);
                oprot.writeI32(struct.version);
                oprot.writeFieldEnd();
            }
            if (struct.dataSource != null && struct.isSetDataSource()) {
                oprot.writeFieldBegin(DATA_SOURCE_FIELD_DESC);
                struct.dataSource.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.selectList != null && struct.isSetSelectList()) {
                oprot.writeFieldBegin(SELECT_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.selectList.size()));
                for (Expression expression : struct.selectList) {
                    expression.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.filterExpression != null && struct.isSetFilterExpression()) {
                oprot.writeFieldBegin(FILTER_EXPRESSION_FIELD_DESC);
                struct.filterExpression.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.groupByList != null && struct.isSetGroupByList()) {
                oprot.writeFieldBegin(GROUP_BY_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.groupByList.size()));
                for (Expression expression : struct.groupByList) {
                    expression.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.orderByList != null && struct.isSetOrderByList()) {
                oprot.writeFieldBegin(ORDER_BY_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.orderByList.size()));
                for (Expression expression : struct.orderByList) {
                    expression.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.havingExpression != null && struct.isSetHavingExpression()) {
                oprot.writeFieldBegin(HAVING_EXPRESSION_FIELD_DESC);
                struct.havingExpression.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetLimit()) {
                oprot.writeFieldBegin(LIMIT_FIELD_DESC);
                oprot.writeI32(struct.limit);
                oprot.writeFieldEnd();
            }
            if (struct.isSetOffset()) {
                oprot.writeFieldBegin(OFFSET_FIELD_DESC);
                oprot.writeI32(struct.offset);
                oprot.writeFieldEnd();
            }
            if (struct.debugOptions != null && struct.isSetDebugOptions()) {
                oprot.writeFieldBegin(DEBUG_OPTIONS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.debugOptions.size()));
                for (Map.Entry entry : struct.debugOptions.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.queryOptions != null && struct.isSetQueryOptions()) {
                oprot.writeFieldBegin(QUERY_OPTIONS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.queryOptions.size()));
                for (Map.Entry entry : struct.queryOptions.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PinotQueryStandardSchemeFactory
    implements SchemeFactory {
        private PinotQueryStandardSchemeFactory() {
        }

        public PinotQueryStandardScheme getScheme() {
            return new PinotQueryStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VERSION(1, "version"),
        DATA_SOURCE(2, "dataSource"),
        SELECT_LIST(3, "selectList"),
        FILTER_EXPRESSION(4, "filterExpression"),
        GROUP_BY_LIST(5, "groupByList"),
        ORDER_BY_LIST(6, "orderByList"),
        HAVING_EXPRESSION(7, "havingExpression"),
        LIMIT(8, "limit"),
        OFFSET(9, "offset"),
        DEBUG_OPTIONS(10, "debugOptions"),
        QUERY_OPTIONS(11, "queryOptions");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VERSION;
                }
                case 2: {
                    return DATA_SOURCE;
                }
                case 3: {
                    return SELECT_LIST;
                }
                case 4: {
                    return FILTER_EXPRESSION;
                }
                case 5: {
                    return GROUP_BY_LIST;
                }
                case 6: {
                    return ORDER_BY_LIST;
                }
                case 7: {
                    return HAVING_EXPRESSION;
                }
                case 8: {
                    return LIMIT;
                }
                case 9: {
                    return OFFSET;
                }
                case 10: {
                    return DEBUG_OPTIONS;
                }
                case 11: {
                    return QUERY_OPTIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

