/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.minion.RealtimeToOfflineSegmentsTaskMetadata;
import org.apache.zookeeper.data.Stat;

public final class MinionTaskMetadataUtils {
    private MinionTaskMetadataUtils() {
    }

    @Nullable
    public static ZNRecord fetchMinionTaskMetadataZNRecord(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        Stat stat;
        String path = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskType, tableNameWithType);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat = new Stat(), AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    @Nullable
    public static RealtimeToOfflineSegmentsTaskMetadata getRealtimeToOfflineSegmentsTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        ZNRecord znRecord = MinionTaskMetadataUtils.fetchMinionTaskMetadataZNRecord(propertyStore, taskType, tableNameWithType);
        return znRecord != null ? RealtimeToOfflineSegmentsTaskMetadata.fromZNRecord(znRecord) : null;
    }

    public static void persistRealtimeToOfflineSegmentsTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, RealtimeToOfflineSegmentsTaskMetadata realtimeToOfflineSegmentsTaskMetadata, int expectedVersion) {
        String path = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskType, realtimeToOfflineSegmentsTaskMetadata.getTableNameWithType());
        if (!propertyStore.set(path, (Object)realtimeToOfflineSegmentsTaskMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to persist minion RealtimeToOfflineSegmentsTask metadata: " + realtimeToOfflineSegmentsTaskMetadata);
        }
    }
}

