/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum ServerGauge implements AbstractMetrics.Gauge
{
    DOCUMENT_COUNT("documents", false),
    SEGMENT_COUNT("segments", false),
    LLC_PARTITION_CONSUMING("state", false),
    HIGHEST_KAFKA_OFFSET_CONSUMED("messages", false),
    HIGHEST_STREAM_OFFSET_CONSUMED("messages", false),
    LAST_REALTIME_SEGMENT_CREATION_DURATION_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_CREATION_WAIT_TIME_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_INITIAL_CONSUMPTION_DURATION_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_CATCHUP_DURATION_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_COMPLETION_DURATION_SECONDS("seconds", false),
    REALTIME_OFFHEAP_MEMORY_USED("bytes", false),
    REALTIME_SEGMENT_NUM_PARTITIONS("realtimeSegmentNumPartitions", false),
    LLC_SIMULTANEOUS_SEGMENT_BUILDS("llcSimultaneousSegmentBuilds", true),
    UPSERT_PRIMARY_KEYS_COUNT("upsertPrimaryKeysCount", false);

    private final String gaugeName;
    private final String unit;
    private final boolean global;

    private ServerGauge(String unit, boolean global) {
        this.unit = unit;
        this.global = global;
        this.gaugeName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getGaugeName() {
        return this.gaugeName;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }
}

