/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Stoppable;
import com.yammer.metrics.core.Timer;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.AggregatedCounter;
import org.apache.pinot.common.metrics.AggregatedHistogram;
import org.apache.pinot.common.metrics.AggregatedLongGauge;
import org.apache.pinot.common.metrics.AggregatedMeter;
import org.apache.pinot.common.metrics.AggregatedMetricsRegistry;
import org.apache.pinot.common.metrics.JmxReporterMetricsRegistryRegistrationListener;
import org.apache.pinot.common.metrics.MetricsRegistryRegistrationListener;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsHelper.class);
    private static Map<MetricsRegistry, Boolean> metricsRegistryMap = new ConcurrentHashMap<MetricsRegistry, Boolean>();
    private static Map<MetricsRegistryRegistrationListener, Boolean> metricsRegistryRegistrationListenersMap = new ConcurrentHashMap<MetricsRegistryRegistrationListener, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeMetrics(PinotConfiguration configuration) {
        Class<MetricsHelper> clazz = MetricsHelper.class;
        synchronized (MetricsHelper.class) {
            List listenerClassNames = configuration.getProperty("metricsRegistryRegistrationListeners", Arrays.asList(JmxReporterMetricsRegistryRegistrationListener.class.getName()));
            for (String listenerClassName : listenerClassNames) {
                try {
                    Class<?> clazz2 = Class.forName(listenerClassName);
                    Constructor<?> defaultConstructor = clazz2.getDeclaredConstructor(new Class[0]);
                    MetricsRegistryRegistrationListener listener = (MetricsRegistryRegistrationListener)defaultConstructor.newInstance(new Object[0]);
                    LOGGER.info("Registering metricsRegistry to listener {}", (Object)listenerClassName);
                    MetricsHelper.addMetricsRegistryRegistrationListener(listener);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception while initializing MetricsRegistryRegistrationListener " + listenerClassName, (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOGGER.info("Number of listeners got registered: {}", (Object)metricsRegistryRegistrationListenersMap.size());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMetricsRegistryRegistrationListener(MetricsRegistryRegistrationListener listener) {
        Class<MetricsHelper> clazz = MetricsHelper.class;
        synchronized (MetricsHelper.class) {
            metricsRegistryRegistrationListenersMap.put(listener, Boolean.TRUE);
            Set<MetricsRegistry> metricsRegistries = metricsRegistryMap.keySet();
            LOGGER.info("Number of metrics registry: {}", (Object)metricsRegistries.size());
            for (MetricsRegistry metricsRegistry : metricsRegistries) {
                listener.onMetricsRegistryRegistered(metricsRegistry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMetricsRegistry(MetricsRegistry registry) {
        Class<MetricsHelper> clazz = MetricsHelper.class;
        synchronized (MetricsHelper.class) {
            metricsRegistryMap.put(registry, Boolean.TRUE);
            Set<MetricsRegistryRegistrationListener> metricsRegistryRegistrationListeners = metricsRegistryRegistrationListenersMap.keySet();
            for (MetricsRegistryRegistrationListener metricsRegistryRegistrationListener : metricsRegistryRegistrationListeners) {
                metricsRegistryRegistrationListener.onMetricsRegistryRegistered(registry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Meter newMeter(MetricsRegistry registry, MetricName name, String eventType, TimeUnit unit) {
        if (registry != null) {
            return registry.newMeter(name, eventType, unit);
        }
        return Metrics.newMeter((MetricName)name, (String)eventType, (TimeUnit)unit);
    }

    public static <T extends Metered & Stoppable> AggregatedMeter<T> newAggregatedMeter(AggregatedMetricsRegistry registry, MetricName name) {
        if (registry != null) {
            return registry.newAggregatedMeter(name);
        }
        return new AggregatedMeter();
    }

    public static Counter newCounter(MetricsRegistry registry, MetricName name) {
        if (registry != null) {
            return registry.newCounter(name);
        }
        return Metrics.newCounter((MetricName)name);
    }

    public static AggregatedCounter newAggregatedCounter(AggregatedMetricsRegistry registry, MetricName name) {
        if (registry != null) {
            return registry.newAggregatedCounter(name);
        }
        return new AggregatedCounter();
    }

    public static Histogram newHistogram(MetricsRegistry registry, MetricName name, boolean biased) {
        if (registry != null) {
            return registry.newHistogram(name, biased);
        }
        return Metrics.newHistogram((MetricName)name, (boolean)biased);
    }

    public static <T extends Sampling> AggregatedHistogram<T> newAggregatedHistogram(AggregatedMetricsRegistry registry, MetricName name) {
        if (registry != null) {
            return registry.newAggregatedHistogram(name);
        }
        return new AggregatedHistogram();
    }

    public static <T> Gauge<T> newGauge(MetricsRegistry registry, MetricName name, Gauge<T> gauge) {
        if (registry != null) {
            return registry.newGauge(name, gauge);
        }
        return Metrics.newGauge((MetricName)name, gauge);
    }

    public static void removeMetric(MetricsRegistry registry, MetricName name) {
        if (registry != null) {
            registry.removeMetric(name);
        } else {
            Metrics.defaultRegistry().removeMetric(name);
        }
    }

    public static <T extends Number, V extends Gauge<T>> AggregatedLongGauge<T, V> newAggregatedLongGauge(AggregatedMetricsRegistry registry, MetricName name) {
        if (registry != null) {
            return registry.newAggregatedLongGauge(name);
        }
        return new AggregatedLongGauge();
    }

    public static Timer newTimer(MetricsRegistry registry, MetricName name, TimeUnit durationUnit, TimeUnit rateUnit) {
        if (registry != null) {
            return registry.newTimer(name, durationUnit, rateUnit);
        }
        return Metrics.newTimer((MetricName)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit);
    }

    public static TimerContext startTimer() {
        return new TimerContext();
    }

    public static class TimerContext {
        private final long _startTimeNanos = System.nanoTime();
        private long _stopTimeNanos;
        private boolean _isDone = false;

        public void stop() {
            this._isDone = true;
            this._stopTimeNanos = System.nanoTime();
        }

        public long getLatencyMs() {
            if (!this._isDone) {
                this.stop();
            }
            return (this._stopTimeNanos - this._startTimeNanos) / 1000000L;
        }
    }
}

