/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.Stoppable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class AggregatedMeter<T extends Metered & Stoppable>
implements Metered,
Stoppable {
    public static final long SECONDS_IN_ONE_MIN = 60L;
    public static final long SECONDS_IN_FIVE_MIN = 300L;
    public static final long SECONDS_IN_FIFTEEN_MIN = 900L;
    private final List<T> _meters = new CopyOnWriteArrayList<T>();
    private static final long DEFAULT_REFRESH_MS = 60000L;
    private final long _refreshMs;
    private volatile long _lastRefreshedTime;
    private volatile long _count;
    private volatile double _oneMinRate;
    private volatile double _fiveMinRate;
    private volatile double _fifteenMinRate;
    private volatile double _meanRate;

    public AggregatedMeter() {
        this._refreshMs = 60000L;
    }

    public AggregatedMeter(long refreshMs) {
        this._refreshMs = refreshMs;
    }

    public AggregatedMeter<T> addAll(Collection<T> meters) {
        this._meters.addAll(meters);
        return this;
    }

    public AggregatedMeter<T> add(T meter) {
        this._meters.add(meter);
        return this;
    }

    public boolean remove(T meter) {
        return this._meters.remove(meter);
    }

    public void stop() {
        for (Metered m : this._meters) {
            ((Stoppable)m).stop();
        }
    }

    public <T2> void processWith(MetricProcessor<T2> processor, MetricName name, T2 context) throws Exception {
        for (Metered m : this._meters) {
            m.processWith(processor, name, context);
        }
    }

    private void refreshIfElapsed() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastRefreshedTime > this._refreshMs && !this._meters.isEmpty()) {
            this.refresh();
            this._lastRefreshedTime = currentTime;
        }
    }

    public void refresh() {
        long oneMinSum = 0L;
        long fiveMinSum = 0L;
        long fifteenMinSum = 0L;
        long meanSum = 0L;
        int count = this._meters.size();
        this._count = 0L;
        for (Metered m : this._meters) {
            oneMinSum = (long)((double)oneMinSum + m.oneMinuteRate() * 60.0);
            fiveMinSum = (long)((double)fiveMinSum + m.fiveMinuteRate() * 300.0);
            fifteenMinSum = (long)((double)fifteenMinSum + m.fifteenMinuteRate() * 900.0);
            meanSum = (long)((double)meanSum + m.meanRate() * (double)m.count());
            this._count += m.count();
        }
        this._oneMinRate = (double)oneMinSum / ((double)((long)count * 60L) * 1.0);
        this._fiveMinRate = (double)fiveMinSum / ((double)((long)count * 300L) * 1.0);
        this._fifteenMinRate = (double)fifteenMinSum / ((double)((long)count * 900L) * 1.0);
        this._meanRate = meanSum / this._count;
    }

    public TimeUnit rateUnit() {
        if (this._meters.isEmpty()) {
            return null;
        }
        return ((Metered)this._meters.get(0)).rateUnit();
    }

    public String eventType() {
        if (this._meters.isEmpty()) {
            return null;
        }
        return ((Metered)this._meters.get(0)).eventType();
    }

    public long count() {
        this.refreshIfElapsed();
        return this._count;
    }

    public double fifteenMinuteRate() {
        this.refreshIfElapsed();
        return this._fifteenMinRate;
    }

    public double fiveMinuteRate() {
        this.refreshIfElapsed();
        return this._fiveMinRate;
    }

    public double meanRate() {
        this.refreshIfElapsed();
        return this._meanRate;
    }

    public double oneMinuteRate() {
        this.refreshIfElapsed();
        return this._oneMinRate;
    }
}

