/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.yammer.metrics.core.Gauge;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AggregatedLongGauge<T extends Number, V extends Gauge<T>>
extends Gauge<Long> {
    private final List<Gauge<T>> _gauges = new CopyOnWriteArrayList<Gauge<T>>();
    private static final long DEFAULT_REFRESH_MS = 60000L;
    private final long _refreshMs;
    private volatile long _lastRefreshedTime;
    private volatile long _value;

    public AggregatedLongGauge(long refreshMs) {
        this._refreshMs = refreshMs;
    }

    public AggregatedLongGauge() {
        this._refreshMs = 60000L;
    }

    public AggregatedLongGauge<T, V> addAll(Collection<Gauge<T>> gauges) {
        this._gauges.addAll(gauges);
        return this;
    }

    public AggregatedLongGauge<T, V> add(Gauge<T> gauge) {
        this._gauges.add(gauge);
        return this;
    }

    public boolean remove(Gauge<T> gauge) {
        return this._gauges.remove(gauge);
    }

    private void refreshIfElapsed() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastRefreshedTime > this._refreshMs && !this._gauges.isEmpty()) {
            this.refresh();
            this._lastRefreshedTime = currentTime;
        }
    }

    public void refresh() {
        long sum = 0L;
        for (Gauge<T> gauge : this._gauges) {
            sum += ((Number)gauge.value()).longValue();
        }
        this._value = sum / (long)this._gauges.size();
    }

    public Long value() {
        this.refreshIfElapsed();
        return this._value;
    }
}

