/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class AggregatedCounter
implements Metric {
    private final CopyOnWriteArrayList<Metric> _counters = new CopyOnWriteArrayList();
    private static final long DEFAULT_REFRESH_MS = 60000L;
    private final long _refreshMs;
    private long _lastRefreshedTime;
    private volatile long _count;

    public <T> void processWith(MetricProcessor<T> processor, MetricName name, T context) throws Exception {
        for (Metric c : this._counters) {
            c.processWith(processor, name, context);
        }
    }

    public AggregatedCounter() {
        this._refreshMs = 60000L;
    }

    public AggregatedCounter(long refreshMs) {
        this._refreshMs = refreshMs;
    }

    public AggregatedCounter addAll(Collection<? extends Metric> counters) {
        this._counters.addAll(counters);
        return this;
    }

    public AggregatedCounter add(Metric counter) {
        this._counters.add(counter);
        return this;
    }

    public boolean remove(Metric counter) {
        return this._counters.remove(counter);
    }

    public long count() {
        this.refreshIfElapsed();
        return this._count;
    }

    private void refreshIfElapsed() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastRefreshedTime > this._refreshMs && !this._counters.isEmpty()) {
            this.refresh();
            this._lastRefreshedTime = currentTime;
        }
    }

    public void refresh() {
        long count = 0L;
        for (Metric m : this._counters) {
            if (m instanceof Counter) {
                count += ((Counter)m).count();
                continue;
            }
            if (!(m instanceof AggregatedCounter)) continue;
            count += ((AggregatedCounter)m).count();
        }
        this._count = count;
    }
}

