/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.spi.utils.JsonUtils;

public class SegmentZKMetadataCustomMapModifier {
    private static final String MAP_MODIFY_MODE_KEY = "mapModifyMode";
    private static final String MAP_KEY = "map";
    private final ModifyMode _modifyMode;
    private final Map<String, String> _map;

    public SegmentZKMetadataCustomMapModifier(@Nonnull ModifyMode modifyMode, @Nullable Map<String, String> map) {
        this._modifyMode = modifyMode;
        this._map = map == null || map.isEmpty() ? null : map;
    }

    public SegmentZKMetadataCustomMapModifier(@Nonnull String jsonString) throws IOException {
        JsonNode jsonNode = JsonUtils.stringToJsonNode((String)jsonString);
        this._modifyMode = ModifyMode.valueOf(jsonNode.get(MAP_MODIFY_MODE_KEY).asText());
        JsonNode jsonMap = jsonNode.get(MAP_KEY);
        if (jsonMap == null || jsonMap.size() == 0) {
            this._map = null;
        } else {
            this._map = new HashMap<String, String>();
            Iterator keys = jsonMap.fieldNames();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this._map.put(key, jsonMap.get(key).asText());
            }
        }
    }

    public String toJsonString() {
        ObjectNode objectNode = JsonUtils.newObjectNode();
        objectNode.put(MAP_MODIFY_MODE_KEY, this._modifyMode.toString());
        objectNode.set(MAP_KEY, JsonUtils.objectToJsonNode(this._map));
        return objectNode.toString();
    }

    public Map<String, String> modifyMap(@Nullable Map<String, String> existingMap) {
        if (this._modifyMode == ModifyMode.REPLACE || existingMap == null || existingMap.isEmpty()) {
            if (this._map == null) {
                return null;
            }
            return new HashMap<String, String>(this._map);
        }
        if (this._map != null) {
            existingMap.putAll(this._map);
        }
        return existingMap;
    }

    public static enum ModifyMode {
        REPLACE,
        UPDATE;

    }
}

