/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.spi.utils.EqualityUtils;

public class LLCRealtimeSegmentZKMetadata
extends RealtimeSegmentZKMetadata {
    private static final String START_OFFSET = "segment.realtime.startOffset";
    private static final String END_OFFSET = "segment.realtime.endOffset";
    private static final String NUM_REPLICAS = "segment.realtime.numReplicas";
    public static final String DOWNLOAD_URL = "segment.realtime.download.url";
    private String _startOffset;
    private String _endOffset;
    private int _numReplicas;
    private String _downloadUrl = null;

    public LLCRealtimeSegmentZKMetadata() {
    }

    public LLCRealtimeSegmentZKMetadata(ZNRecord znRecord) {
        super(znRecord);
        this._startOffset = znRecord.getSimpleField(START_OFFSET);
        this._numReplicas = Integer.valueOf(znRecord.getSimpleField(NUM_REPLICAS));
        this._endOffset = znRecord.getSimpleField(END_OFFSET);
        this._downloadUrl = znRecord.getSimpleField(DOWNLOAD_URL);
    }

    public String getStartOffset() {
        return this._startOffset;
    }

    public String getEndOffset() {
        return this._endOffset;
    }

    public int getNumReplicas() {
        return this._numReplicas;
    }

    public void setStartOffset(String startOffset) {
        this._startOffset = startOffset;
    }

    public void setEndOffset(String endOffset) {
        this._endOffset = endOffset;
    }

    public void setNumReplicas(int numReplicas) {
        this._numReplicas = numReplicas;
    }

    public String getDownloadUrl() {
        return this._downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this._downloadUrl = downloadUrl;
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = super.toZNRecord();
        znRecord.setSimpleField(START_OFFSET, this._startOffset);
        if (this._endOffset == null) {
            this._endOffset = Long.toString(Long.MAX_VALUE);
        }
        znRecord.setSimpleField(END_OFFSET, this._endOffset);
        znRecord.setIntField(NUM_REPLICAS, this._numReplicas);
        znRecord.setSimpleField(DOWNLOAD_URL, this._downloadUrl);
        return znRecord;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String newline = "\n";
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newline);
        result.append("  " + super.getClass().getName() + " : " + super.toString());
        result.append(newline);
        result.append("  segment.realtime.startOffset : " + this._startOffset + ",");
        result.append(newline);
        result.append("  segment.realtime.download.url : " + this._downloadUrl + ",");
        result.append(newline);
        result.append("  segment.realtime.endOffset : " + this._endOffset);
        result.append(newline);
        result.append("}");
        return result.toString();
    }

    @Override
    public boolean equals(Object segmentMetadata) {
        if (EqualityUtils.isSameReference((Object)this, (Object)segmentMetadata)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)segmentMetadata)) {
            return false;
        }
        LLCRealtimeSegmentZKMetadata metadata = (LLCRealtimeSegmentZKMetadata)segmentMetadata;
        return super.equals(metadata) && EqualityUtils.isEqual((Object)this._startOffset, (Object)metadata._startOffset) && EqualityUtils.isEqual((Object)this._endOffset, (Object)metadata._endOffset) && EqualityUtils.isEqual((Object)this._downloadUrl, (Object)metadata._downloadUrl) && EqualityUtils.isEqual((int)this._numReplicas, (int)metadata._numReplicas);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._startOffset);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._endOffset);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._numReplicas);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._downloadUrl);
        return result;
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> configMap = super.toMap();
        configMap.put(START_OFFSET, this._startOffset);
        configMap.put(END_OFFSET, this._endOffset);
        configMap.put(NUM_REPLICAS, Integer.toString(this._numReplicas));
        configMap.put(DOWNLOAD_URL, this._downloadUrl);
        return configMap;
    }
}

