/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.instance;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadata;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public final class InstanceZKMetadata
implements ZKMetadata {
    private static final String KAFKA_HIGH_LEVEL_CONSUMER_GROUP_MAP = "KAFKA_HLC_GROUP_MAP";
    private static final String KAFKA_HIGH_LEVEL_CONSUMER_PARTITION_MAP = "KAFKA_HLC_PARTITION_MAP";
    private String _id = null;
    private String _instanceName = null;
    private int _instancePort;
    private String _instanceType = null;
    private Map<String, String> _groupIdMap = new HashMap<String, String>();
    private Map<String, String> _partitionMap = new HashMap<String, String>();

    public InstanceZKMetadata() {
    }

    public InstanceZKMetadata(ZNRecord record) {
        this._id = record.getId();
        this.setInstanceConfigFromId(this._id);
        this._groupIdMap.putAll(record.getMapField(KAFKA_HIGH_LEVEL_CONSUMER_GROUP_MAP));
        this._partitionMap.putAll(record.getMapField(KAFKA_HIGH_LEVEL_CONSUMER_PARTITION_MAP));
    }

    private void setInstanceConfigFromId(String id) {
        String[] instanceConfigs = id.split("_");
        assert (instanceConfigs.length == 3);
        this.setInstanceType(instanceConfigs[0]);
        this.setInstanceName(instanceConfigs[1]);
        this.setInstancePort(Integer.parseInt(instanceConfigs[2]));
    }

    public int getInstancePort() {
        return this._instancePort;
    }

    public void setInstancePort(int instancePort) {
        this._instancePort = instancePort;
    }

    public String getInstanceType() {
        return this._instanceType;
    }

    public void setInstanceType(String instanceType) {
        this._instanceType = instanceType;
    }

    public String getId() {
        if (this._id == null) {
            this._id = this.buildIdFromInstanceConfig();
        }
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public void setInstanceName(String instanceName) {
        this._instanceName = instanceName;
    }

    public String getGroupId(String resourceName) {
        return this._groupIdMap.get(TableNameBuilder.REALTIME.tableNameWithType(resourceName));
    }

    public void setGroupId(String resourceName, String groupId) {
        this._groupIdMap.put(TableNameBuilder.REALTIME.tableNameWithType(resourceName), groupId);
    }

    public String getPartition(String resourceName) {
        return this._partitionMap.get(TableNameBuilder.REALTIME.tableNameWithType(resourceName));
    }

    public void setPartition(String resourceName, String partition) {
        this._partitionMap.put(TableNameBuilder.REALTIME.tableNameWithType(resourceName), partition);
    }

    public void removeResource(String resourceName) {
        this._groupIdMap.remove(resourceName);
        this._partitionMap.remove(resourceName);
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this.getId());
        znRecord.setMapField(KAFKA_HIGH_LEVEL_CONSUMER_GROUP_MAP, this._groupIdMap);
        znRecord.setMapField(KAFKA_HIGH_LEVEL_CONSUMER_PARTITION_MAP, this._partitionMap);
        return znRecord;
    }

    private String buildIdFromInstanceConfig() {
        return StringUtil.join("_", this._instanceType, this._instanceName, this._instancePort + "");
    }

    public boolean equals(Object instanceMetadata) {
        if (EqualityUtils.isSameReference((Object)this, (Object)instanceMetadata)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)instanceMetadata)) {
            return false;
        }
        InstanceZKMetadata metadata = (InstanceZKMetadata)instanceMetadata;
        return EqualityUtils.isEqual((Object)this._id, (Object)metadata._id) && EqualityUtils.isEqual((Object)this._instanceName, (Object)metadata._instanceName) && EqualityUtils.isEqual((Object)this._instanceType, (Object)metadata._instanceType) && EqualityUtils.isEqual((int)this._instancePort, (int)metadata._instancePort) && EqualityUtils.isEqual(this._groupIdMap, metadata._groupIdMap) && EqualityUtils.isEqual(this._partitionMap, metadata._partitionMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._id);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._instanceName);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._instancePort);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._instanceType);
        result = EqualityUtils.hashCodeOf((int)result, this._groupIdMap);
        result = EqualityUtils.hashCodeOf((int)result, this._partitionMap);
        return result;
    }
}

