/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.zookeeper.data.Stat;

public class SegmentLineageAccessHelper {
    public static ZNRecord getSegmentLineageZNRecord(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        Stat stat;
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentLineage(tableNameWithType);
        ZNRecord segmentLineageZNRecord = (ZNRecord)propertyStore.get(path, stat = new Stat(), AccessOption.PERSISTENT);
        if (segmentLineageZNRecord != null) {
            segmentLineageZNRecord.setVersion(stat.getVersion());
        }
        return segmentLineageZNRecord;
    }

    public static SegmentLineage getSegmentLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        ZNRecord znRecord = SegmentLineageAccessHelper.getSegmentLineageZNRecord(propertyStore, tableNameWithType);
        SegmentLineage segmentMergeLineage = null;
        if (znRecord != null) {
            segmentMergeLineage = SegmentLineage.fromZNRecord(znRecord);
        }
        return segmentMergeLineage;
    }

    public static boolean writeSegmentLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, SegmentLineage segmentLineage, int expectedVersion) {
        String tableNameWithType = segmentLineage.getTableNameWithType();
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentLineage(tableNameWithType);
        return propertyStore.set(path, (Object)segmentLineage.toZNRecord(), expectedVersion, AccessOption.PERSISTENT);
    }
}

