/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class StringFunctions {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    private StringFunctions() {
    }

    @ScalarFunction
    public static String reverse(String input) {
        return StringUtils.reverse((String)input);
    }

    @ScalarFunction
    public static String lower(String input) {
        return input.toLowerCase();
    }

    @ScalarFunction
    public static String upper(String input) {
        return input.toUpperCase();
    }

    @ScalarFunction
    public static String substr(String input, int beginIndex) {
        return input.substring(beginIndex);
    }

    @ScalarFunction
    public static String substr(String input, int beginIndex, int endIndex) {
        if (endIndex == -1) {
            return StringFunctions.substr(input, beginIndex);
        }
        return input.substring(beginIndex, endIndex);
    }

    @ScalarFunction
    public static String concat(String input1, String input2, String seperator) {
        String result = input1;
        result = result + seperator + input2;
        return result;
    }

    @ScalarFunction
    public static String trim(String input) {
        return input.trim();
    }

    @ScalarFunction
    public static String ltrim(String input) {
        return LTRIM.matcher(input).replaceAll("");
    }

    @ScalarFunction
    public static String rtrim(String input) {
        return RTRIM.matcher(input).replaceAll("");
    }

    @ScalarFunction
    public static int length(String input) {
        return input.length();
    }

    @ScalarFunction
    public static int strpos(String input, String find, int instance) {
        return StringUtils.ordinalIndexOf((CharSequence)input, (CharSequence)find, (int)instance);
    }

    @ScalarFunction
    public static boolean startsWith(String input, String prefix) {
        return input.startsWith(prefix);
    }

    @ScalarFunction
    public static String replace(String input, String find, String substitute) {
        return input.replaceAll(find, substitute);
    }

    @ScalarFunction
    public static String rpad(String input, int size, String pad) {
        return StringUtils.rightPad((String)input, (int)size, (String)pad);
    }

    @ScalarFunction
    public static String lpad(String input, int size, String pad) {
        return StringUtils.leftPad((String)input, (int)size, (String)pad);
    }

    @ScalarFunction
    public static int codepoint(String input) {
        return input.codePointAt(0);
    }

    @ScalarFunction
    public static String chr(int codepoint) {
        char[] result = Character.toChars(codepoint);
        return new String(result);
    }
}

