/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.function.DateTimePatternHandler;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeFunctions {
    private DateTimeFunctions() {
    }

    @ScalarFunction
    public static long toEpochSeconds(long millis) {
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @ScalarFunction
    public static long toEpochMinutes(long millis) {
        return TimeUnit.MILLISECONDS.toMinutes(millis);
    }

    @ScalarFunction
    public static long toEpochHours(long millis) {
        return TimeUnit.MILLISECONDS.toHours(millis);
    }

    @ScalarFunction
    public static long toEpochDays(long millis) {
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarFunction
    public static long toEpochSecondsRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochMinutesRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochHoursRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toHours(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochDaysRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toDays(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochSecondsBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / bucket;
    }

    @ScalarFunction
    public static long toEpochMinutesBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / bucket;
    }

    @ScalarFunction
    public static long toEpochHoursBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toHours(millis) / bucket;
    }

    @ScalarFunction
    public static long toEpochDaysBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toDays(millis) / bucket;
    }

    @ScalarFunction
    public static long fromEpochSeconds(long seconds) {
        return TimeUnit.SECONDS.toMillis(seconds);
    }

    @ScalarFunction
    public static long fromEpochMinutes(long minutes) {
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    @ScalarFunction
    public static long fromEpochHours(long hours) {
        return TimeUnit.HOURS.toMillis(hours);
    }

    @ScalarFunction
    public static long fromEpochDays(long days) {
        return TimeUnit.DAYS.toMillis(days);
    }

    @ScalarFunction
    public static long fromEpochSecondsBucket(long seconds, long bucket) {
        return TimeUnit.SECONDS.toMillis(seconds * bucket);
    }

    @ScalarFunction
    public static long fromEpochMinutesBucket(long minutes, long bucket) {
        return TimeUnit.MINUTES.toMillis(minutes * bucket);
    }

    @ScalarFunction
    public static long fromEpochHoursBucket(long hours, long bucket) {
        return TimeUnit.HOURS.toMillis(hours * bucket);
    }

    @ScalarFunction
    public static long fromEpochDaysBucket(long days, long bucket) {
        return TimeUnit.DAYS.toMillis(days * bucket);
    }

    @ScalarFunction
    public static String toDateTime(long millis, String pattern) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern);
    }

    @ScalarFunction
    public static long fromDateTime(String dateTimeString, String pattern) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern);
    }

    @ScalarFunction
    public static long round(long timeValue, long roundToNearest) {
        return timeValue / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long now() {
        return System.currentTimeMillis();
    }

    @ScalarFunction
    public static int timezoneHour(String timezoneId) {
        return new DateTime((long)DateTimeZone.forID((String)timezoneId).getOffset(null), DateTimeZone.UTC).getHourOfDay();
    }

    @ScalarFunction
    public static int timezoneMinute(String timezoneId) {
        return new DateTime((long)DateTimeZone.forID((String)timezoneId).getOffset(null), DateTimeZone.UTC).getMinuteOfHour();
    }

    @ScalarFunction
    public static int year(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getYear();
    }

    @ScalarFunction
    public static int year(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getYear();
    }

    @ScalarFunction
    public static int yearOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekyear();
    }

    @ScalarFunction
    public static int yearOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekyear();
    }

    @ScalarFunction
    public static int yow(long millis) {
        return DateTimeFunctions.yearOfWeek(millis);
    }

    @ScalarFunction
    public static int yow(long millis, String timezoneId) {
        return DateTimeFunctions.yearOfWeek(millis, timezoneId);
    }

    @ScalarFunction
    public static int quarter(long millis) {
        return (DateTimeFunctions.month(millis) - 1) / 3 + 1;
    }

    @ScalarFunction
    public static int quarter(long millis, String timezoneId) {
        return (DateTimeFunctions.month(millis, timezoneId) - 1) / 3 + 1;
    }

    @ScalarFunction
    public static int month(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMonthOfYear();
    }

    @ScalarFunction
    public static int month(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMonthOfYear();
    }

    @ScalarFunction
    public static int week(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekOfWeekyear();
    }

    @ScalarFunction
    public static int week(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekOfWeekyear();
    }

    @ScalarFunction
    public static int weekOfYear(long millis) {
        return DateTimeFunctions.week(millis);
    }

    @ScalarFunction
    public static int weekOfYear(long millis, String timezoneId) {
        return DateTimeFunctions.week(millis, timezoneId);
    }

    @ScalarFunction
    public static int dayOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfYear();
    }

    @ScalarFunction
    public static int dayOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfYear();
    }

    @ScalarFunction
    public static int doy(long millis) {
        return DateTimeFunctions.dayOfYear(millis);
    }

    @ScalarFunction
    public static int doy(long millis, String timezoneId) {
        return DateTimeFunctions.dayOfYear(millis, timezoneId);
    }

    @ScalarFunction
    public static int day(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfMonth();
    }

    @ScalarFunction
    public static int day(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfMonth();
    }

    @ScalarFunction
    public static int dayOfMonth(long millis) {
        return DateTimeFunctions.day(millis);
    }

    @ScalarFunction
    public static int dayOfMonth(long millis, String timezoneId) {
        return DateTimeFunctions.day(millis, timezoneId);
    }

    @ScalarFunction
    public static int dayOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfWeek();
    }

    @ScalarFunction
    public static int dayOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfWeek();
    }

    @ScalarFunction
    public static int dow(long millis) {
        return DateTimeFunctions.dayOfWeek(millis);
    }

    @ScalarFunction
    public static int dow(long millis, String timezoneId) {
        return DateTimeFunctions.dayOfWeek(millis, timezoneId);
    }

    @ScalarFunction
    public static int hour(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getHourOfDay();
    }

    @ScalarFunction
    public static int hour(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getHourOfDay();
    }

    @ScalarFunction
    public static int minute(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMinuteOfHour();
    }

    @ScalarFunction
    public static int minute(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMinuteOfHour();
    }

    @ScalarFunction
    public static int second(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getSecondOfMinute();
    }

    @ScalarFunction
    public static int second(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getSecondOfMinute();
    }

    @ScalarFunction
    public static int millisecond(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMillisOfSecond();
    }

    @ScalarFunction
    public static int millisecond(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMillisOfSecond();
    }
}

