/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class DataTypeConversionFunctions {
    private DataTypeConversionFunctions() {
    }

    @ScalarFunction
    public static byte[] bigDecimalToBytes(String number) {
        BigDecimal bigDecimal = new BigDecimal(number);
        return DataTypeConversionFunctions.bigDecimalToBytes(bigDecimal);
    }

    @ScalarFunction
    public static String bytesToBigDecimal(byte[] bytes) {
        BigDecimal number = DataTypeConversionFunctions.bytesToBigDecimalObject(bytes);
        return number.toString();
    }

    @ScalarFunction
    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    @ScalarFunction
    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }

    public static BigDecimal bytesToBigDecimalObject(byte[] bytes) {
        int scale = 0;
        scale += bytes[0] << 8;
        byte[] vals = new byte[bytes.length - 2];
        System.arraycopy(bytes, 2, vals, 0, vals.length);
        BigInteger unscaled = new BigInteger(vals);
        BigDecimal number = new BigDecimal(unscaled, scale += bytes[1]);
        return number;
    }

    public static byte[] bigDecimalToBytes(BigDecimal bigDecimal) {
        int scale = bigDecimal.scale();
        BigInteger unscaled = bigDecimal.unscaledValue();
        byte[] value = unscaled.toByteArray();
        byte[] bigDecimalBytesArray = new byte[value.length + 2];
        bigDecimalBytesArray[0] = (byte)(scale >>> 8);
        bigDecimalBytesArray[1] = (byte)scale;
        System.arraycopy(value, 0, bigDecimalBytesArray, 2, value.length);
        return bigDecimalBytesArray;
    }

    @ScalarFunction
    public static byte[] base64Encode(byte[] input) {
        return Base64.getEncoder().encodeToString(input).getBytes();
    }

    @ScalarFunction
    public static byte[] base64Decode(String input) {
        return Base64.getDecoder().decode(input.getBytes());
    }
}

