/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import org.apache.pinot.common.function.FunctionRegistry;

public enum TransformFunctionType {
    ADD("add"),
    SUB("sub"),
    MULT("mult"),
    DIV("div"),
    MOD("mod"),
    PLUS("plus"),
    MINUS("minus"),
    TIMES("times"),
    DIVIDE("divide"),
    ABS("abs"),
    CEIL("ceil"),
    EXP("exp"),
    FLOOR("floor"),
    LN("ln"),
    SQRT("sqrt"),
    EQUALS("equals"),
    NOT_EQUALS("not_equals"),
    GREATER_THAN("greater_than"),
    GREATER_THAN_OR_EQUAL("greater_than_or_equal"),
    LESS_THAN("less_than"),
    LESS_THAN_OR_EQUAL("less_than_or_equal"),
    CAST("cast"),
    CASE("case"),
    JSONEXTRACTSCALAR("jsonExtractScalar"),
    JSONEXTRACTKEY("jsonExtractKey"),
    TIMECONVERT("timeConvert"),
    DATETIMECONVERT("dateTimeConvert"),
    DATETRUNC("dateTrunc"),
    ARRAYLENGTH("arrayLength"),
    ARRAYAVERAGE("arrayAverage"),
    ARRAYMIN("arrayMin"),
    ARRAYMAX("arrayMax"),
    ARRAYSUM("arraySum"),
    VALUEIN("valueIn"),
    MAPVALUE("mapValue"),
    INIDSET("inIdSet"),
    GROOVY("groovy"),
    SCALAR("scalar"),
    ST_GEOG_FROM_TEXT("ST_GeogFromText"),
    ST_GEOM_FROM_TEXT("ST_GeomFromText"),
    ST_GEOG_FROM_WKB("ST_GeogFromWKB"),
    ST_GEOM_FROM_WKB("ST_GeomFromWKB"),
    ST_POINT("ST_Point"),
    ST_POLYGON("ST_Polygon"),
    ST_AREA("ST_Area"),
    ST_DISTANCE("ST_Distance"),
    ST_GEOMETRY_TYPE("ST_GeometryType"),
    ST_AS_BINARY("ST_AsBinary"),
    ST_AS_TEXT("ST_AsText"),
    ST_CONTAINS("ST_Contains"),
    ST_EQUALS("ST_Equals");

    private final String _name;

    private TransformFunctionType(String name) {
        this._name = name;
    }

    public static TransformFunctionType getTransformFunctionType(String functionName) {
        String upperCaseFunctionName = functionName.toUpperCase();
        try {
            return TransformFunctionType.valueOf(upperCaseFunctionName);
        }
        catch (IllegalArgumentException e) {
            if (FunctionRegistry.containsFunction(functionName)) {
                return SCALAR;
            }
            if (upperCaseFunctionName.contains("_")) {
                return TransformFunctionType.getTransformFunctionType(upperCaseFunctionName.replace("_", ""));
            }
            throw new IllegalArgumentException("Invalid transform function name: " + functionName);
        }
    }

    public String getName() {
        return this._name;
    }
}

