/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.spi.data.FieldSpec;

public class FunctionUtils {
    private static final Map<Class<?>, PinotDataType> PARAMETER_TYPE_MAP = new HashMap<Class<?>, PinotDataType>(){
        {
            this.put(Integer.TYPE, PinotDataType.INTEGER);
            this.put(Integer.class, PinotDataType.INTEGER);
            this.put(Long.TYPE, PinotDataType.LONG);
            this.put(Long.class, PinotDataType.LONG);
            this.put(Float.TYPE, PinotDataType.FLOAT);
            this.put(Float.class, PinotDataType.FLOAT);
            this.put(Double.TYPE, PinotDataType.DOUBLE);
            this.put(Double.class, PinotDataType.DOUBLE);
            this.put(String.class, PinotDataType.STRING);
            this.put(byte[].class, PinotDataType.BYTES);
        }
    };
    private static final Map<Class<?>, PinotDataType> ARGUMENT_TYPE_MAP = new HashMap<Class<?>, PinotDataType>(){
        {
            this.put(Byte.class, PinotDataType.BYTE);
            this.put(Boolean.class, PinotDataType.BOOLEAN);
            this.put(Character.class, PinotDataType.CHARACTER);
            this.put(Short.class, PinotDataType.SHORT);
            this.put(Integer.class, PinotDataType.INTEGER);
            this.put(Long.class, PinotDataType.LONG);
            this.put(Float.class, PinotDataType.FLOAT);
            this.put(Double.class, PinotDataType.DOUBLE);
            this.put(String.class, PinotDataType.STRING);
            this.put(byte[].class, PinotDataType.BYTES);
        }
    };
    private static final Map<Class<?>, FieldSpec.DataType> DATA_TYPE_MAP = new HashMap<Class<?>, FieldSpec.DataType>(){
        {
            this.put(Integer.TYPE, FieldSpec.DataType.INT);
            this.put(Integer.class, FieldSpec.DataType.INT);
            this.put(Long.TYPE, FieldSpec.DataType.LONG);
            this.put(Long.class, FieldSpec.DataType.LONG);
            this.put(Float.TYPE, FieldSpec.DataType.FLOAT);
            this.put(Float.class, FieldSpec.DataType.FLOAT);
            this.put(Double.TYPE, FieldSpec.DataType.DOUBLE);
            this.put(Double.class, FieldSpec.DataType.DOUBLE);
            this.put(String.class, FieldSpec.DataType.STRING);
            this.put(byte[].class, FieldSpec.DataType.BYTES);
        }
    };
    private static final Map<Class<?>, DataSchema.ColumnDataType> COLUMN_DATA_TYPE_MAP = new HashMap<Class<?>, DataSchema.ColumnDataType>(){
        {
            this.put(Integer.TYPE, DataSchema.ColumnDataType.INT);
            this.put(Integer.class, DataSchema.ColumnDataType.INT);
            this.put(Long.TYPE, DataSchema.ColumnDataType.LONG);
            this.put(Long.class, DataSchema.ColumnDataType.LONG);
            this.put(Float.TYPE, DataSchema.ColumnDataType.FLOAT);
            this.put(Float.class, DataSchema.ColumnDataType.FLOAT);
            this.put(Double.TYPE, DataSchema.ColumnDataType.DOUBLE);
            this.put(Double.class, DataSchema.ColumnDataType.DOUBLE);
            this.put(String.class, DataSchema.ColumnDataType.STRING);
            this.put(byte[].class, DataSchema.ColumnDataType.BYTES);
        }
    };

    private FunctionUtils() {
    }

    @Nullable
    public static PinotDataType getParameterType(Class<?> clazz) {
        return PARAMETER_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static PinotDataType getArgumentType(Class<?> clazz) {
        return ARGUMENT_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static FieldSpec.DataType getDataType(Class<?> clazz) {
        return DATA_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static DataSchema.ColumnDataType getColumnDataType(Class<?> clazz) {
        return COLUMN_DATA_TYPE_MAP.get(clazz);
    }
}

