/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import org.apache.commons.lang3.StringUtils;

public enum AggregationFunctionType {
    COUNT("count"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    SUMPRECISION("sumPrecision"),
    AVG("avg"),
    MINMAXRANGE("minMaxRange"),
    DISTINCTCOUNT("distinctCount"),
    DISTINCTCOUNTBITMAP("distinctCountBitmap"),
    SEGMENTPARTITIONEDDISTINCTCOUNT("segmentPartitionedDistinctCount"),
    DISTINCTCOUNTHLL("distinctCountHLL"),
    DISTINCTCOUNTRAWHLL("distinctCountRawHLL"),
    FASTHLL("fastHLL"),
    DISTINCTCOUNTTHETASKETCH("distinctCountThetaSketch"),
    DISTINCTCOUNTRAWTHETASKETCH("distinctCountRawThetaSketch"),
    PERCENTILE("percentile"),
    PERCENTILEEST("percentileEst"),
    PERCENTILETDIGEST("percentileTDigest"),
    IDSET("idSet"),
    STUNION("STUnion"),
    COUNTMV("countMV"),
    MINMV("minMV"),
    MAXMV("maxMV"),
    SUMMV("sumMV"),
    AVGMV("avgMV"),
    MINMAXRANGEMV("minMaxRangeMV"),
    DISTINCTCOUNTMV("distinctCountMV"),
    DISTINCTCOUNTBITMAPMV("distinctCountBitmapMV"),
    DISTINCTCOUNTHLLMV("distinctCountHLLMV"),
    DISTINCTCOUNTRAWHLLMV("distinctCountRawHLLMV"),
    PERCENTILEMV("percentileMV"),
    PERCENTILEESTMV("percentileEstMV"),
    PERCENTILETDIGESTMV("percentileTDigestMV"),
    DISTINCT("distinct");

    private final String _name;

    private AggregationFunctionType(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public static AggregationFunctionType getAggregationFunctionType(String functionName) {
        String upperCaseFunctionName = StringUtils.remove((String)functionName, (char)'_').toUpperCase();
        if (upperCaseFunctionName.startsWith("PERCENTILE")) {
            String remainingFunctionName = upperCaseFunctionName.substring(10);
            if (remainingFunctionName.isEmpty() || remainingFunctionName.matches("\\d+")) {
                return PERCENTILE;
            }
            if (remainingFunctionName.equals("EST") || remainingFunctionName.matches("EST\\d+")) {
                return PERCENTILEEST;
            }
            if (remainingFunctionName.equals("TDIGEST") || remainingFunctionName.matches("TDIGEST\\d+")) {
                return PERCENTILETDIGEST;
            }
            if (remainingFunctionName.equals("MV") || remainingFunctionName.matches("\\d+MV")) {
                return PERCENTILEMV;
            }
            if (remainingFunctionName.equals("ESTMV") || remainingFunctionName.matches("EST\\d+MV")) {
                return PERCENTILEESTMV;
            }
            if (remainingFunctionName.equals("TDIGESTMV") || remainingFunctionName.matches("TDIGEST\\d+MV")) {
                return PERCENTILETDIGESTMV;
            }
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
        try {
            return AggregationFunctionType.valueOf(upperCaseFunctionName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
    }
}

