/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.assignment;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.spi.config.table.ReplicaGroupStrategyConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceTagPoolConfig;

public class InstanceAssignmentConfigUtils {
    private InstanceAssignmentConfigUtils() {
    }

    public static boolean shouldRelocateCompletedSegments(TableConfig tableConfig) {
        Map instanceAssignmentConfigMap = tableConfig.getInstanceAssignmentConfigMap();
        return instanceAssignmentConfigMap != null && instanceAssignmentConfigMap.get(InstancePartitionsType.COMPLETED) != null || TagNameUtils.isRelocateCompletedSegments(tableConfig.getTenantConfig());
    }

    public static boolean allowInstanceAssignment(TableConfig tableConfig, InstancePartitionsType instancePartitionsType) {
        TableType tableType = tableConfig.getTableType();
        Map instanceAssignmentConfigMap = tableConfig.getInstanceAssignmentConfigMap();
        switch (instancePartitionsType) {
            case OFFLINE: {
                return tableType == TableType.OFFLINE && (instanceAssignmentConfigMap != null && instanceAssignmentConfigMap.get(InstancePartitionsType.OFFLINE) != null || CommonConstants.Segment.AssignmentStrategy.REPLICA_GROUP_SEGMENT_ASSIGNMENT_STRATEGY.equalsIgnoreCase(tableConfig.getValidationConfig().getSegmentAssignmentStrategy()));
            }
            case CONSUMING: 
            case COMPLETED: {
                return tableType == TableType.REALTIME && instanceAssignmentConfigMap != null && instanceAssignmentConfigMap.get(instancePartitionsType) != null;
            }
        }
        throw new IllegalStateException();
    }

    public static InstanceAssignmentConfig getInstanceAssignmentConfig(TableConfig tableConfig, InstancePartitionsType instancePartitionsType) {
        InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig;
        InstanceAssignmentConfig instanceAssignmentConfig;
        Preconditions.checkState((boolean)InstanceAssignmentConfigUtils.allowInstanceAssignment(tableConfig, instancePartitionsType), (Object)"Instance assignment is not allowed for the given table config");
        Map instanceAssignmentConfigMap = tableConfig.getInstanceAssignmentConfigMap();
        if (instanceAssignmentConfigMap != null && (instanceAssignmentConfig = (InstanceAssignmentConfig)instanceAssignmentConfigMap.get(instancePartitionsType)) != null) {
            return instanceAssignmentConfig;
        }
        InstanceTagPoolConfig tagPoolConfig = new InstanceTagPoolConfig(TagNameUtils.extractOfflineServerTag(tableConfig.getTenantConfig()), false, 0, null);
        SegmentsValidationAndRetentionConfig segmentConfig = tableConfig.getValidationConfig();
        int numReplicaGroups = segmentConfig.getReplicationNumber();
        ReplicaGroupStrategyConfig replicaGroupStrategyConfig = segmentConfig.getReplicaGroupStrategyConfig();
        Preconditions.checkState((replicaGroupStrategyConfig != null ? 1 : 0) != 0, (Object)"Failed to find the replica-group strategy config");
        String partitionColumn = replicaGroupStrategyConfig.getPartitionColumn();
        if (partitionColumn != null) {
            int numPartitions = tableConfig.getIndexingConfig().getSegmentPartitionConfig().getNumPartitions(partitionColumn);
            Preconditions.checkState((numPartitions > 0 ? 1 : 0) != 0, (String)"Number of partitions for column: %s is not properly configured", (Object)partitionColumn);
            replicaGroupPartitionConfig = new InstanceReplicaGroupPartitionConfig(true, 0, numReplicaGroups, 0, numPartitions, replicaGroupStrategyConfig.getNumInstancesPerPartition());
        } else {
            replicaGroupPartitionConfig = new InstanceReplicaGroupPartitionConfig(true, 0, numReplicaGroups, replicaGroupStrategyConfig.getNumInstancesPerPartition(), 0, 0);
        }
        return new InstanceAssignmentConfig(tagPoolConfig, null, replicaGroupPartitionConfig);
    }
}

