/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final AtomicLong _uniqueIdGen = new AtomicLong(1L);

    public static void rethrowException(Throwable t) {
        Utils.rethrowExceptionInner(t);
    }

    private static <T extends Throwable> void rethrowExceptionInner(Throwable exception) throws T {
        throw exception;
    }

    public static String getCallingMethodDetails() {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            return e.getStackTrace()[2].toString();
        }
    }

    public static long getUniqueId() {
        return _uniqueIdGen.incrementAndGet();
    }

    public static String toCamelCase(String text) {
        int length = text.length();
        StringBuilder builder = new StringBuilder(length);
        boolean capitalizeNextChar = false;
        for (int i = 0; i < length; ++i) {
            char theChar = text.charAt(i);
            if (Character.isLetterOrDigit(theChar) || theChar == '.') {
                if (capitalizeNextChar) {
                    builder.append(Character.toUpperCase(theChar));
                    capitalizeNextChar = false;
                    continue;
                }
                builder.append(theChar);
                continue;
            }
            capitalizeNextChar = true;
        }
        return builder.toString();
    }

    public static void logVersions() {
        for (Map.Entry<String, String> titleVersionEntry : Utils.getComponentVersions().entrySet()) {
            LOGGER.info("Using {} {}", (Object)titleVersionEntry.getKey(), (Object)titleVersionEntry.getValue());
        }
    }

    public static Map<String, String> getComponentVersions() {
        ClassLoader classLoader;
        HashMap<String, String> componentVersions = new HashMap<String, String>();
        for (classLoader = Utils.class.getClassLoader(); classLoader != null && !(classLoader instanceof URLClassLoader); classLoader = classLoader.getParent()) {
        }
        if (classLoader != null) {
            URL[] urls;
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL url : urls = urlClassLoader.getURLs()) {
                try {
                    JarURLConnection jarURLConnection;
                    Attributes attributes;
                    URL jarUrl = new URL("jar", "", url + "!/");
                    URLConnection connection = jarUrl.openConnection();
                    if (!(connection instanceof JarURLConnection) || (attributes = (jarURLConnection = (JarURLConnection)connection).getMainAttributes()) == null) continue;
                    String implementationTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    String implementationVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    if (implementationTitle == null || !implementationTitle.contains("pinot")) continue;
                    componentVersions.put(implementationTitle, implementationVersion);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return componentVersions;
    }
}

