/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ValueColumn
extends JsonTableColumnDefinition {
    private final Identifier name;
    private final DataType type;
    private final Optional<StringLiteral> jsonPath;
    private final JsonValue.EmptyOrErrorBehavior emptyBehavior;
    private final Optional<Expression> emptyDefault;
    private final Optional<JsonValue.EmptyOrErrorBehavior> errorBehavior;
    private final Optional<Expression> errorDefault;

    public ValueColumn(NodeLocation location, Identifier name, DataType type, Optional<StringLiteral> jsonPath, JsonValue.EmptyOrErrorBehavior emptyBehavior, Optional<Expression> emptyDefault, Optional<JsonValue.EmptyOrErrorBehavior> errorBehavior, Optional<Expression> errorDefault) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.jsonPath = Objects.requireNonNull(jsonPath, "jsonPath is null");
        this.emptyBehavior = Objects.requireNonNull(emptyBehavior, "emptyBehavior is null");
        this.emptyDefault = Objects.requireNonNull(emptyDefault, "emptyDefault is null");
        Preconditions.checkArgument((emptyBehavior == JsonValue.EmptyOrErrorBehavior.DEFAULT || !emptyDefault.isPresent() ? 1 : 0) != 0, (Object)"default value can be specified only for DEFAULT ... ON EMPTY option");
        Preconditions.checkArgument((emptyBehavior != JsonValue.EmptyOrErrorBehavior.DEFAULT || emptyDefault.isPresent() ? 1 : 0) != 0, (Object)"DEFAULT ... ON EMPTY option requires default value");
        this.errorBehavior = Objects.requireNonNull(errorBehavior, "errorBehavior is null");
        this.errorDefault = Objects.requireNonNull(errorDefault, "errorDefault is null");
        Preconditions.checkArgument((errorBehavior.isPresent() && errorBehavior.get() == JsonValue.EmptyOrErrorBehavior.DEFAULT || !errorDefault.isPresent() ? 1 : 0) != 0, (Object)"default value can be specified only for DEFAULT ... ON ERROR option");
        Preconditions.checkArgument((!errorBehavior.isPresent() || errorBehavior.get() != JsonValue.EmptyOrErrorBehavior.DEFAULT || errorDefault.isPresent() ? 1 : 0) != 0, (Object)"DEFAULT ... ON ERROR option requires default value");
    }

    public Identifier getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public Optional<StringLiteral> getJsonPath() {
        return this.jsonPath;
    }

    public JsonValue.EmptyOrErrorBehavior getEmptyBehavior() {
        return this.emptyBehavior;
    }

    public Optional<Expression> getEmptyDefault() {
        return this.emptyDefault;
    }

    public Optional<JsonValue.EmptyOrErrorBehavior> getErrorBehavior() {
        return this.errorBehavior;
    }

    public Optional<Expression> getErrorDefault() {
        return this.errorDefault;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitValueColumn(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        this.jsonPath.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        this.emptyDefault.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        this.errorDefault.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("jsonPath", this.jsonPath.orElse(null)).add("emptyBehavior", (Object)this.emptyBehavior).add("emptyDefault", this.emptyDefault.orElse(null)).add("errorBehavior", this.errorBehavior.orElse(null)).add("errorDefault", this.errorDefault.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueColumn that = (ValueColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.jsonPath, that.jsonPath) && this.emptyBehavior == that.emptyBehavior && Objects.equals(this.emptyDefault, that.emptyDefault) && Objects.equals(this.errorBehavior, that.errorBehavior) && Objects.equals(this.errorDefault, that.errorDefault);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.jsonPath, this.emptyBehavior, this.emptyDefault, this.errorBehavior, this.errorDefault});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!ValueColumn.sameClass(this, other)) {
            return false;
        }
        ValueColumn otherValueColumn = (ValueColumn)other;
        return this.name.equals(otherValueColumn.name) && this.type.equals(otherValueColumn.type) && this.emptyBehavior == otherValueColumn.emptyBehavior && Objects.equals(this.errorBehavior, otherValueColumn.errorBehavior);
    }
}

