/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonExists
extends Expression {
    private final JsonPathInvocation jsonPathInvocation;
    private final ErrorBehavior errorBehavior;

    public JsonExists(Optional<NodeLocation> location, JsonPathInvocation jsonPathInvocation, ErrorBehavior errorBehavior) {
        super(location);
        Objects.requireNonNull(jsonPathInvocation, "jsonPathInvocation is null");
        Objects.requireNonNull(errorBehavior, "errorBehavior is null");
        this.jsonPathInvocation = jsonPathInvocation;
        this.errorBehavior = errorBehavior;
    }

    public JsonPathInvocation getJsonPathInvocation() {
        return this.jsonPathInvocation;
    }

    public ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonExists(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.jsonPathInvocation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonExists that = (JsonExists)o;
        return Objects.equals(this.jsonPathInvocation, that.jsonPathInvocation) && this.errorBehavior == that.errorBehavior;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonPathInvocation, this.errorBehavior});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonExists.sameClass(this, other)) {
            return false;
        }
        return this.errorBehavior == ((JsonExists)other).errorBehavior;
    }

    public static enum ErrorBehavior {
        FALSE,
        TRUE,
        UNKNOWN,
        ERROR;

    }
}

