/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath.tree;

import io.trino.sql.jsonpath.tree.JsonPathTreeVisitor;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.Predicate;
import java.util.Objects;

public class ComparisonPredicate
extends Predicate {
    private final Operator operator;
    private final PathNode left;
    private final PathNode right;

    public ComparisonPredicate(Operator operator, PathNode left, PathNode right) {
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    @Override
    public <R, C> R accept(JsonPathTreeVisitor<R, C> visitor, C context) {
        return visitor.visitComparisonPredicate(this, context);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public PathNode getLeft() {
        return this.left;
    }

    public PathNode getRight() {
        return this.right;
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        GREATER_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN_OR_EQUAL;

    }
}

