/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Set;

public final class TypeUtils {
    private static final Set<Type> PUSHDOWN_SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)DateType.DATE, (Object[])new Type[]{TimeType.TIME_MILLIS, TimestampType.TIMESTAMP_MILLIS, TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS});

    private TypeUtils() {
    }

    public static boolean isJsonType(Type type) {
        return type.getBaseName().equals("json");
    }

    public static boolean isPushdownSupportedType(Type type) {
        return type instanceof CharType || type instanceof VarcharType || type instanceof DecimalType || type instanceof ObjectIdType || PUSHDOWN_SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }
}

