/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class RemoteTableName {
    private final String databaseName;
    private final String collectionName;

    @JsonCreator
    public RemoteTableName(@JsonProperty String databaseName, @JsonProperty String collectionName) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.collectionName = Objects.requireNonNull(collectionName, "collectionName is null");
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteTableName that = (RemoteTableName)o;
        return this.databaseName.equals(that.databaseName) && this.collectionName.equals(that.collectionName);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.collectionName);
    }

    public String toString() {
        return this.databaseName + "." + this.collectionName;
    }
}

