/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.mongodb.connection.SslSettings;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ssl.SslUtils;
import io.trino.plugin.mongodb.MongoClientSettingConfigurator;
import io.trino.plugin.mongodb.MongoSslConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public class MongoSslModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(MongoSslConfig.class);
    }

    @ProvidesIntoSet
    @Singleton
    public MongoClientSettingConfigurator sslSpecificConfigurator(MongoSslConfig config) {
        return options -> options.applyToSslSettings(builder -> {
            builder.enabled(true);
            MongoSslModule.buildSslContext(config.getKeystorePath(), config.getKeystorePassword(), config.getTruststorePath(), config.getTruststorePassword()).ifPresent(arg_0 -> ((SslSettings.Builder)builder).context(arg_0));
        });
    }

    private static Optional<SSLContext> buildSslContext(Optional<File> keystorePath, Optional<String> keystorePassword, Optional<File> truststorePath, Optional<String> truststorePassword) {
        if (keystorePath.isEmpty() && truststorePath.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SslUtils.createSSLContext(keystorePath, keystorePassword, truststorePath, truststorePassword));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }
}

